/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.driver.v3;

import com.datastax.driver.mapping.DefaultNamingStrategy;
import com.datastax.driver.mapping.NamingConventions;
import com.datastax.driver.mapping.NamingStrategy;
import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Frozen;
import com.datastax.driver.mapping.annotations.FrozenKey;
import com.datastax.driver.mapping.annotations.FrozenValue;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.datastax.driver.mapping.annotations.Transient;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.reflection.Accessor;

public class GeneratorV3
extends Generator {
    private NamingStrategy namingStrategy = new DefaultNamingStrategy(NamingConventions.LOWER_CAMEL_CASE, NamingConventions.LOWER_SNAKE_CASE);

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    public String toCassandraName(String javaPropertyName) {
        return this.namingStrategy.toCassandraName(javaPropertyName);
    }

    @Override
    public Class<? extends Annotation> tableAnnotation() {
        return Table.class;
    }

    @Override
    public Annotation tableAnnotation(Class sourceClass) {
        return sourceClass.getAnnotation(Table.class);
    }

    @Override
    public String tableKeyspace(Class sourceClass) {
        Table table = sourceClass.getAnnotation(Table.class);
        if (table != null) {
            return table.keyspace();
        }
        return null;
    }

    @Override
    public String tableName(Class sourceClass) {
        Table table = sourceClass.getAnnotation(Table.class);
        if (table == null) {
            throw new IllegalArgumentException("Class " + sourceClass + " is not annotated with @Table");
        }
        return table.name();
    }

    @Override
    public boolean hasColumnAnnotation(AccessibleObject field) {
        return Accessor.getAnnotation((AccessibleObject)field, Column.class) != null;
    }

    @Override
    public boolean hasColumnAnnotation(PropertyDescriptor desc) {
        return Accessor.getAnnotation((PropertyDescriptor)desc, Column.class) != null;
    }

    @Override
    public String getColumnName(Field field) {
        Column column = (Column)Accessor.getAnnotation((AccessibleObject)field, Column.class);
        String columnName = column == null || column.name().isEmpty() ? this.toCassandraName(field.getName()) : column.name();
        return columnName;
    }

    @Override
    public String getColumnName(PropertyDescriptor descriptor) {
        Column column = (Column)Accessor.getAnnotation((PropertyDescriptor)descriptor, Column.class);
        String columnName = column == null || column.name().isEmpty() ? this.toCassandraName(descriptor.getName()) : column.name();
        return columnName;
    }

    @Override
    public int partitionKeyIndex(AccessibleObject field) {
        PartitionKey annotation = (PartitionKey)Accessor.getAnnotation((AccessibleObject)field, PartitionKey.class);
        if (annotation != null) {
            return annotation.value();
        }
        return -1;
    }

    @Override
    public int partitionKeyIndex(PropertyDescriptor descriptor) {
        PartitionKey annotation = (PartitionKey)Accessor.getAnnotation((PropertyDescriptor)descriptor, PartitionKey.class);
        if (annotation != null) {
            return annotation.value();
        }
        return -1;
    }

    @Override
    public int clusteringColumnIndex(AccessibleObject field) {
        ClusteringColumn annotation = (ClusteringColumn)Accessor.getAnnotation((AccessibleObject)field, ClusteringColumn.class);
        if (annotation != null) {
            return annotation.value();
        }
        return -1;
    }

    @Override
    public int clusteringColumnIndex(PropertyDescriptor descriptor) {
        ClusteringColumn annotation = (ClusteringColumn)Accessor.getAnnotation((PropertyDescriptor)descriptor, ClusteringColumn.class);
        if (annotation != null) {
            return annotation.value();
        }
        return -1;
    }

    @Override
    public boolean isTransient(AccessibleObject field) {
        return Accessor.getAnnotation((AccessibleObject)field, Transient.class) != null;
    }

    @Override
    public boolean isTransient(PropertyDescriptor descriptor) {
        return Accessor.getAnnotation((PropertyDescriptor)descriptor, Transient.class) != null;
    }

    @Override
    public boolean isFrozen(AccessibleObject field) {
        return Accessor.getAnnotation((AccessibleObject)field, Frozen.class) != null;
    }

    @Override
    public boolean isFrozen(PropertyDescriptor descriptor) {
        return Accessor.getAnnotation((PropertyDescriptor)descriptor, Frozen.class) != null;
    }

    @Override
    public boolean isFrozenKey(AccessibleObject field) {
        return Accessor.getAnnotation((AccessibleObject)field, FrozenKey.class) != null;
    }

    @Override
    public boolean isFrozenKey(PropertyDescriptor descriptor) {
        return Accessor.getAnnotation((PropertyDescriptor)descriptor, FrozenKey.class) != null;
    }

    @Override
    public boolean isFrozenValue(AccessibleObject field) {
        return Accessor.getAnnotation((AccessibleObject)field, FrozenValue.class) != null;
    }

    @Override
    public boolean isFrozenValue(PropertyDescriptor descriptor) {
        return Accessor.getAnnotation((PropertyDescriptor)descriptor, FrozenValue.class) != null;
    }
}

