/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Transient;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.cassandra.generator.AbstractGenerator;
import net.e6tech.elements.cassandra.generator.AnnotatedTypeDescriptor;
import net.e6tech.elements.cassandra.generator.ColumnGenerator;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.KeyColumn;

public class TableGenerator
extends AbstractGenerator {
    private Map<String, ColumnGenerator> columnGenerators = new LinkedHashMap<String, ColumnGenerator>();
    private Map<String, String> columnGenerators2 = new LinkedHashMap<String, String>();
    private List<KeyColumn> clusterKeys = new ArrayList<KeyColumn>();
    private List<KeyColumn> partitionKeys = new ArrayList<KeyColumn>();

    TableGenerator(Generator generator, Class entityClass) throws IntrospectionException {
        super(generator);
        Column column;
        LinkedList<Class> classHierarchy = this.analyze(entityClass);
        for (Class cls : classHierarchy) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                ClusteringColumn cc;
                if (Modifier.isStatic(field.getModifiers())) continue;
                column = field.getAnnotation(Column.class);
                Transient trans = field.getAnnotation(Transient.class);
                if (trans != null) continue;
                PartitionKey pk = field.getAnnotation(PartitionKey.class);
                if (pk != null) {
                    this.partitionKeys.add(new KeyColumn(generator.getColumnName(column, field), pk.value()));
                }
                if ((cc = field.getAnnotation(ClusteringColumn.class)) != null) {
                    this.clusterKeys.add(new KeyColumn(generator.getColumnName(column, field), cc.value()));
                }
                ColumnGenerator fieldGen = new ColumnGenerator(generator, field.getGenericType(), new AnnotatedTypeDescriptor(generator, field));
                this.columnGenerators.put(generator.getColumnName(column, field), fieldGen);
                this.columnGenerators2.put(field.getName(), generator.getColumnName(column, field));
            }
        }
        for (PropertyDescriptor desc : Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
            String columnName;
            ColumnGenerator colGen;
            ClusteringColumn cc;
            Transient trans;
            Method method = null;
            Type type = null;
            if (desc.getReadMethod() != null) {
                method = desc.getReadMethod();
                type = method.getGenericReturnType();
            }
            if (method == null || method.getName().equals("getClass") || (trans = method.getAnnotation(Transient.class)) != null) continue;
            column = method.getAnnotation(Column.class);
            PartitionKey pk = method.getAnnotation(PartitionKey.class);
            if (pk != null) {
                this.partitionKeys.add(new KeyColumn(generator.getColumnName(column, method), pk.value()));
            }
            if ((cc = method.getAnnotation(ClusteringColumn.class)) != null) {
                this.clusterKeys.add(new KeyColumn(generator.getColumnName(column, method), cc.value()));
            }
            if ((colGen = this.columnGenerators.get(generator.getColumnName(column, method))) == null && (columnName = this.columnGenerators2.get(desc.getName())) != null && (colGen = this.columnGenerators.get(columnName)) != null) {
                this.columnGenerators.remove(columnName);
            }
            AnnotatedTypeDescriptor fieldTypeDescriptor = colGen != null ? (AnnotatedTypeDescriptor)colGen.getTypeDescriptor() : null;
            ColumnGenerator methGen = new ColumnGenerator(generator, type, new AnnotatedTypeDescriptor(generator, method, fieldTypeDescriptor));
            this.columnGenerators.put(generator.getColumnName(column, method), methGen);
        }
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE IF NOT EXISTS ");
        builder.append(this.fullyQualifiedTableName());
        builder.append(" (\n");
        for (ColumnGenerator gen : this.columnGenerators.values()) {
            builder.append(gen.generate());
            builder.append(",\n");
        }
        Collections.sort(this.partitionKeys, Comparator.comparingInt(KeyColumn::getPosition));
        Collections.sort(this.clusterKeys, Comparator.comparingInt(KeyColumn::getPosition));
        boolean first = true;
        builder.append("PRIMARY KEY (");
        if (this.partitionKeys.size() > 1) {
            builder.append("(");
        }
        for (KeyColumn pk : this.partitionKeys) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(pk.getName());
        }
        if (this.partitionKeys.size() > 1) {
            builder.append(")");
        }
        for (KeyColumn cc : this.clusterKeys) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(cc.getName());
        }
        builder.append(")\n");
        builder.append(")");
        return builder.toString();
    }
}

