/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import com.datastax.driver.mapping.annotations.Table;
import java.util.LinkedList;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.util.StringUtil;
import net.e6tech.elements.common.util.SystemException;

public class AbstractGenerator {
    protected Generator generator;
    private Table table;
    private String keyspace;

    AbstractGenerator(Generator generator) {
        this.generator = generator;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public Table getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.table.name();
    }

    public String getTableKeyspace() {
        return this.table.keyspace();
    }

    protected LinkedList<Class> analyze(Class entityClass) {
        LinkedList<Class> classHierarchy = new LinkedList<Class>();
        for (Class tmp = entityClass; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
            if (this.table == null) {
                this.table = tmp.getAnnotation(Table.class);
            }
            classHierarchy.addFirst(tmp);
        }
        if (this.table == null) {
            throw new SystemException("Class " + entityClass.getName() + " is not annotated with @Table");
        }
        return classHierarchy;
    }

    protected String fullyQualifiedTableName() {
        StringBuilder builder = new StringBuilder();
        if (!StringUtil.isNullOrEmpty((String)this.getTableKeyspace())) {
            builder.append(this.getTableKeyspace()).append(".");
        } else if (!StringUtil.isNullOrEmpty((String)this.getKeyspace())) {
            builder.append(this.getKeyspace()).append(".");
        }
        builder.append(this.getTableName());
        return builder.toString();
    }
}

