/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.mapping.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.datastructure.Pair;

public class Transformer<T, E> {
    private Map<PrimaryKey, T> map = new HashMap<PrimaryKey, T>();
    private Class<T> tableClass;
    private Provision provision;
    private Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    private List<Pair<PrimaryKey, E>> entries = new ArrayList<Pair<PrimaryKey, E>>();

    public Transformer(Provision provision, Class<T> cls) {
        this.provision = provision;
        this.tableClass = cls;
    }

    public Transformer<T, E> transform(Stream<E> stream, BiConsumer<Transformer<T, E>, E> consumer) {
        stream.forEach(e -> consumer.accept(this, e));
        return this;
    }

    public Transformer<T, E> transform(E[] array, BiConsumer<Transformer<T, E>, E> consumer) {
        for (E e : array) {
            consumer.accept(this, e);
        }
        return this;
    }

    public Transformer<T, E> transform(Collection<E> collection, BiConsumer<Transformer<T, E>, E> consumer) {
        for (E e : collection) {
            consumer.accept(this, e);
        }
        return this;
    }

    public Async createAsync() {
        return (Async)this.provision.newInstance(Async.class);
    }

    public Async createAsync(String query) {
        return ((Sibyl)this.provision.getInstance(Sibyl.class)).createAsync(query);
    }

    public Async createAsync(PreparedStatement stmt) {
        return ((Sibyl)this.provision.getInstance(Sibyl.class)).createAsync(stmt);
    }

    public Transformer<T, E> addPrimaryKey(PrimaryKey key, E e) {
        if (key == null) {
            return this;
        }
        this.primaryKeys.add(key);
        this.entries.add(new Pair((Object)key, e));
        return this;
    }

    public Transformer<T, E> load() {
        Sibyl s = (Sibyl)this.provision.getInstance(Sibyl.class);
        s.get(this.keys(), this.tableClass).inExecutionOrder(this.map::put);
        return this;
    }

    public Set<PrimaryKey> keys() {
        return this.primaryKeys;
    }

    public Collection<Pair<PrimaryKey, E>> entries() {
        return this.entries;
    }

    public Transformer<T, E> put(PrimaryKey key, T t) {
        this.map.put(key, t);
        return this;
    }

    public T computeIfAbsent(PrimaryKey key) {
        return this.computeIfAbsent(key, null);
    }

    public T computeIfAbsent(PrimaryKey key, Consumer<T> consumer) {
        return (T)this.map.computeIfAbsent(key, (? super K k) -> {
            try {
                T t = this.tableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.setPrimaryKey(key, t);
                if (consumer != null) {
                    consumer.accept(t);
                    this.setPrimaryKey(key, t);
                }
                return t;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        });
    }

    private Inspector getInspector(Class cls) {
        return ((Sibyl)this.provision.getInstance(Sibyl.class)).getInspector(cls);
    }

    private void setPrimaryKey(PrimaryKey primaryKey, T t) {
        this.getInspector(t.getClass()).setPrimaryKey(primaryKey, t);
    }

    public Transformer<T, E> forEachCreateIfNotExist(BiConsumer<E, T> consumer) {
        for (Pair<PrimaryKey, E> e : this.entries()) {
            T t = this.computeIfAbsent((PrimaryKey)e.key());
            consumer.accept(e.value(), t);
            this.checkpoint(e.value(), t);
        }
        return this;
    }

    public Transformer<T, E> save(Mapper.Option ... options) {
        Sibyl s = (Sibyl)this.provision.getInstance(Sibyl.class);
        s.save(this.values(), this.tableClass, options).inCompletionOrder();
        return this;
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public Set<PrimaryKey> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public void checkpoint(E extraction, T t) {
        Object extractionKey = this.getInspector(extraction.getClass()).getPartitionKey(extraction, 0);
        if (extractionKey == null) {
            return;
        }
        this.getInspector(this.tableClass).setCheckpoint(t, 0, extractionKey);
    }
}

