/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import com.datastax.driver.core.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.etl.PartitionOrderBy;
import net.e6tech.elements.cassandra.etl.PartitionOrderByContext;
import net.e6tech.elements.cassandra.etl.PartitionStrategy;

public class PartitionOrderByStrategy<S extends PartitionOrderBy>
extends PartitionStrategy<S, PartitionOrderByContext> {
    @Override
    public List<S> extract(PartitionOrderByContext context) {
        Class sourceClass = context.getSourceClass();
        PreparedStatement pstmt = context.getPreparedStatements().computeIfAbsent("extract", key -> context.getSession().prepare(context.getExtractionQuery()));
        Async async = context.createAsync(pstmt);
        for (Comparable partition : context.getPartitions()) {
            Comparable startId = context.getStartId(partition);
            Comparable endId = context.getEndId(partition);
            if (endId.compareTo(startId) <= 0) continue;
            startId = endId;
            context.setStartId(partition, startId);
            async.execute(bound -> bound.set(context.getInspector().getPartitionKeyColumn(0), (Object)partition, partition.getClass()).set(context.getInspector().getClusteringKeyColumn(0), (Object)context.getStartId(partition), partition.getClass()));
        }
        ArrayList list = new ArrayList();
        async.inExecutionOrder(rs -> {
            List subList = context.getMapper(sourceClass).map(rs).all();
            if (!subList.isEmpty()) {
                PartitionOrderBy last = (PartitionOrderBy)subList.get(subList.size() - 1);
                context.setEndId((Comparable)context.getInspector().getPartitionKey(last, 0), (Comparable)context.getInspector().getClusteringKey(last, 0));
                list.addAll(subList);
            }
        });
        return list;
    }

    @Override
    public int run(List<Comparable> partitions, PartitionOrderByContext context) {
        List<S> batchResults = null;
        int processedCount = 0;
        context.setPartitions(partitions);
        while (!(batchResults = this.extract(context)).isEmpty()) {
            processedCount += this.load(context, batchResults);
        }
        logger.info("Processed {} instance of {}", (Object)processedCount, (Object)context.extractor());
        return processedCount;
    }
}

