/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.cassandra.etl.PartitionContext;
import net.e6tech.elements.cassandra.etl.PartitionOrderByStrategy;
import net.e6tech.elements.cassandra.etl.PartitionStrategy;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.TextBuilder;

public class PartitionOrderByContext
extends PartitionContext {
    private Map<Comparable, Comparable> startIds = new HashMap<Comparable, Comparable>();
    private Map<Comparable, Comparable> endIds = new HashMap<Comparable, Comparable>();

    public String getExtractionQuery() {
        String clusteringKeyColumn = this.getInspector().getClusteringKeyColumn(0);
        String partitionKeyColumn = this.getInspector().getPartitionKeyColumn(0);
        return TextBuilder.using((String)"select * from ${table} where ${pk} = :${pk} and ${ck} > :${ck} order by ${ck} asc limit ${batchSize}").build("table", (Object)this.tableName(), "pk", (Object)partitionKeyColumn, "ck", (Object)clusteringKeyColumn, "batchSize", (Object)this.getBatchSize());
    }

    @Override
    public PartitionOrderByStrategy createStrategy() {
        return new PartitionOrderByStrategy();
    }

    public Comparable getStartId(Comparable partition) {
        Comparable id = this.startIds.get(partition);
        if (id == null) {
            id = Long.valueOf(0L);
        }
        return id;
    }

    public void setStartId(Comparable hour, Comparable id) {
        this.startIds.put(hour, id);
    }

    public Comparable getEndId(Comparable partition) {
        Comparable id = this.endIds.get(partition);
        if (id == null) {
            id = Long.valueOf(1L);
        }
        return id;
    }

    public void setEndId(Comparable partition, Comparable id) {
        this.endIds.put(partition, id);
    }

    @Override
    public void reset() {
        super.reset();
        this.startIds.clear();
        this.endIds.clear();
    }

    @Override
    public PartitionOrderByContext run(Class<? extends PartitionStrategy> cls) {
        if (PartitionOrderByStrategy.class.isAssignableFrom(cls)) {
            try {
                PartitionOrderByStrategy strategy = (PartitionOrderByStrategy)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.setImportedCount(strategy.run(this));
            }
            catch (Exception ex) {
                throw new SystemException((Throwable)ex);
            }
        } else {
            super.run(cls);
        }
        return this;
    }
}

