/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.datastax.driver.mapping.annotations.Transient;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.cassandra.etl.PartitionUnit;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.cassandra.generator.Checkpoint;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.util.SystemException;

public class Inspector {
    private Generator generator;
    private Class sourceClass;
    private boolean initialized = false;
    private TimeUnit timeUnit;
    private List<Descriptor> partitionKeys = new ArrayList<Descriptor>();
    private List<Descriptor> clusteringKeys = new ArrayList<Descriptor>();
    private List<Descriptor> checkpoints = new ArrayList<Descriptor>();

    public Inspector(Class sourceClass, Generator generator) {
        this.sourceClass = sourceClass;
        this.generator = generator;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void addPartitionKey(Descriptor descriptor) {
        this.partitionKeys.add(descriptor);
        Collections.sort(this.partitionKeys, Comparator.comparingInt(p -> p.position));
    }

    public void addClusteringKey(Descriptor descriptor) {
        this.clusteringKeys.add(descriptor);
        Collections.sort(this.clusteringKeys, Comparator.comparingInt(p -> p.position));
    }

    public String getPartitionKeyColumn(int n) {
        if (this.partitionKeys.size() <= n) {
            return null;
        }
        return this.partitionKeys.get((int)n).columnName;
    }

    public Class getPartitionKeyClass(int n) {
        return this.getKeyClass(this.partitionKeys, n);
    }

    private Class getKeyClass(List<Descriptor> keys, int n) {
        if (keys.size() <= n) {
            return null;
        }
        Descriptor descriptor = keys.get(n);
        if (descriptor.getPropertyDescriptor() != null) {
            return descriptor.getPropertyDescriptor().getReadMethod().getReturnType();
        }
        return descriptor.getField().getType();
    }

    public Object getPartitionKey(Object object, int n) {
        return this.getKey(this.partitionKeys, object, n);
    }

    private Object getKey(List<Descriptor> keys, Object object, int n) {
        if (keys.size() <= n) {
            return null;
        }
        return this.get(keys.get(n), object);
    }

    public String getCheckpointColumn(int n) {
        if (this.checkpoints.size() <= n) {
            return null;
        }
        return this.checkpoints.get((int)n).columnName;
    }

    public void setCheckpoint(Object object, int n, Object value) {
        if (this.checkpoints.size() <= n) {
            return;
        }
        this.set(this.checkpoints.get(n), object, value);
    }

    public String getClusteringKeyColumn(int n) {
        if (this.clusteringKeys.size() <= n) {
            return null;
        }
        return this.clusteringKeys.get((int)n).columnName;
    }

    public Class getClusteringKeyClass(int n) {
        return this.getKeyClass(this.clusteringKeys, n);
    }

    public Object getClusteringKey(Object object, int n) {
        return this.getKey(this.clusteringKeys, object, n);
    }

    public String tableName() {
        Table table = this.sourceClass.getAnnotation(Table.class);
        if (table == null) {
            throw new IllegalArgumentException("Class " + this.sourceClass + " is not annotated with @Table");
        }
        return table.name();
    }

    private Object get(Descriptor descriptor, Object object) {
        try {
            if (descriptor.getPropertyDescriptor() != null && descriptor.getPropertyDescriptor().getReadMethod() != null) {
                return descriptor.getPropertyDescriptor().getReadMethod().invoke(object, new Object[0]);
            }
            return descriptor.field.get(object);
        }
        catch (Exception ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    private void set(Descriptor descriptor, Object object, Object value) {
        try {
            if (descriptor.getPropertyDescriptor() != null && descriptor.getPropertyDescriptor().getWriteMethod() != null) {
                descriptor.getPropertyDescriptor().getWriteMethod().invoke(object, value);
            } else {
                descriptor.field.set(object, value);
            }
        }
        catch (Exception ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setPrimaryKey(PrimaryKey key, Object object) {
        try {
            int idx = 0;
            for (Descriptor descriptor : this.partitionKeys) {
                if (key.length() <= idx) break;
                this.set(descriptor, object, key.get(idx));
                ++idx;
            }
            for (Descriptor descriptor : this.clusteringKeys) {
                if (key.length() > idx) {
                    this.set(descriptor, object, key.get(idx));
                    ++idx;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public PrimaryKey getPrimaryKey(Object object) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Descriptor descriptor : this.partitionKeys) {
                if (descriptor.getPropertyDescriptor() != null && descriptor.getPropertyDescriptor().getReadMethod() != null) {
                    list.add(descriptor.getPropertyDescriptor().getReadMethod().invoke(object, new Object[0]));
                    continue;
                }
                list.add(descriptor.field.get(object));
            }
            for (Descriptor descriptor : this.clusteringKeys) {
                if (descriptor.getPropertyDescriptor() != null && descriptor.getPropertyDescriptor().getReadMethod() != null) {
                    list.add(descriptor.getPropertyDescriptor().getReadMethod().invoke(object, new Object[0]));
                    continue;
                }
                list.add(descriptor.field.get(object));
            }
            return new PrimaryKey(list.toArray(new Object[0]));
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void initialize() {
        Transient trans;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HashMap<String, Descriptor> propertyMap = new HashMap<String, Descriptor>();
        HashMap<String, Descriptor> spkMap = new HashMap<String, Descriptor>();
        Generator generator = this.getGenerator();
        for (Class cls = this.getSourceClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            Object[] fields;
            Object[] objectArray = fields = cls.getDeclaredFields();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Descriptor descriptor;
                Object field = objectArray[i];
                if (Modifier.isStrict(((Field)field).getModifiers()) || (trans = ((Field)field).getAnnotation(Transient.class)) != null) continue;
                ClusteringColumn cc = ((Field)field).getAnnotation(ClusteringColumn.class);
                PartitionKey pk = ((Field)field).getAnnotation(PartitionKey.class);
                PartitionUnit unit = ((Field)field).getAnnotation(PartitionUnit.class);
                Checkpoint spk = ((Field)field).getAnnotation(Checkpoint.class);
                Column column = ((Field)field).getAnnotation(Column.class);
                if (cc != null) {
                    descriptor = new Descriptor(cc.value(), generator.getColumnName(column, (Field)field), ((Field)field).getName());
                    descriptor.field = field;
                    this.clusteringKeys.add(descriptor);
                    ((Field)field).setAccessible(true);
                    propertyMap.put(((Field)field).getName(), descriptor);
                    propertyMap.put(descriptor.columnName, descriptor);
                }
                if (pk != null) {
                    descriptor = new Descriptor(pk.value(), generator.getColumnName(column, (Field)field), ((Field)field).getName());
                    descriptor.field = field;
                    this.partitionKeys.add(descriptor);
                    ((Field)field).setAccessible(true);
                    propertyMap.put(((Field)field).getName(), descriptor);
                    propertyMap.put(descriptor.columnName, descriptor);
                    if (unit != null && pk.value() == 0) {
                        this.timeUnit = unit.value();
                    }
                }
                if (spk == null) continue;
                descriptor = new Descriptor(spk.value(), generator.getColumnName(column, (Field)field), ((Field)field).getName());
                descriptor.field = field;
                ((Field)field).setAccessible(true);
                this.checkpoints.add(descriptor);
                spkMap.put(((Field)field).getName(), descriptor);
                spkMap.put(descriptor.columnName, descriptor);
            }
        }
        try {
            for (PropertyDescriptor desc : Introspector.getBeanInfo(this.getSourceClass()).getPropertyDescriptors()) {
                Descriptor spkDescriptor;
                Method m = null;
                if (desc.getReadMethod() != null) {
                    m = desc.getReadMethod();
                }
                if (m == null || m.getName().equals("getClass") || (trans = m.getAnnotation(Transient.class)) != null) continue;
                Column column = m.getAnnotation(Column.class);
                Descriptor descriptor = (Descriptor)propertyMap.get(desc.getName());
                String columnName = generator.getColumnName(column, m);
                if (descriptor == null) {
                    descriptor = (Descriptor)propertyMap.get(columnName);
                }
                ClusteringColumn cc = m.getAnnotation(ClusteringColumn.class);
                PartitionKey pk = m.getAnnotation(PartitionKey.class);
                Checkpoint spk = m.getAnnotation(Checkpoint.class);
                PartitionUnit unit = m.getAnnotation(PartitionUnit.class);
                if (cc != null && descriptor == null) {
                    descriptor = new Descriptor(cc.value(), generator.getColumnName(column, m), desc.getName());
                    this.clusteringKeys.add(descriptor);
                    propertyMap.put(desc.getName(), descriptor);
                    propertyMap.put(descriptor.columnName, descriptor);
                }
                if (pk != null && descriptor == null) {
                    descriptor = new Descriptor(pk.value(), generator.getColumnName(column, m), desc.getName());
                    this.partitionKeys.add(descriptor);
                    propertyMap.put(desc.getName(), descriptor);
                    propertyMap.put(descriptor.columnName, descriptor);
                    if (unit != null && pk.value() == 0) {
                        this.timeUnit = unit.value();
                    }
                }
                if (descriptor != null) {
                    descriptor.setPropertyDescriptor(desc);
                }
                if ((spkDescriptor = (Descriptor)spkMap.get(desc.getName())) == null) {
                    spkDescriptor = (Descriptor)spkMap.get(columnName);
                }
                if (spk != null && spkDescriptor == null) {
                    spkDescriptor = new Descriptor(spk.value(), generator.getColumnName(column, m), desc.getName());
                    this.checkpoints.add(descriptor);
                    spkMap.put(desc.getName(), descriptor);
                    spkMap.put(spkDescriptor.columnName, descriptor);
                }
                if (spkDescriptor == null) continue;
                spkDescriptor.setPropertyDescriptor(desc);
            }
        }
        catch (IntrospectionException e) {
            throw new SystemException((Throwable)e);
        }
        Collections.sort(this.partitionKeys, Comparator.comparingInt(p -> p.position));
        Collections.sort(this.clusteringKeys, Comparator.comparingInt(p -> p.position));
        Collections.sort(this.checkpoints, Comparator.comparingInt(p -> p.position));
    }

    public static class Descriptor {
        int position;
        Field field;
        String columnName;
        String property;
        PropertyDescriptor propertyDescriptor;

        public Descriptor(int pos, String columnName, String property) {
            this.position = pos;
            this.columnName = columnName;
            this.property = property;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDescriptor;
        }

        public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
            this.propertyDescriptor = propertyDescriptor;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }
}

