/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.async;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.common.logging.Logger;

public class AsyncResultSet<D>
extends AsyncFutures<ResultSet, D> {
    static Logger logger = Logger.getLogger();

    AsyncResultSet(Async async, List<ResultSetFuture> futures, Map<ResultSetFuture, Object> futuresData) {
        super(async, futures, futuresData);
    }

    public Async inCompletionOrderRows(Consumer<Row> consumer) {
        ImmutableList list = Futures.inCompletionOrder((Iterable)this.futures);
        this.futuresGet((List<ListenableFuture<ResultSet>>)list, consumer);
        return this.async;
    }

    public Async inExecutionOrderRows(Consumer<Row> consumer) {
        this.futuresGet(this.futures, consumer);
        return this.async;
    }

    private void futuresGet(List<ListenableFuture<ResultSet>> list, Consumer<Row> consumer) {
        for (ListenableFuture<ResultSet> future : list) {
            try {
                for (Row row : (ResultSet)future.get()) {
                    consumer.accept(row);
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Async inExecutionRows(BiConsumer<Row, D> consumer) {
        for (ListenableFuture future : this.futures) {
            try {
                for (Row row : (ResultSet)future.get()) {
                    consumer.accept(row, this.futuresData.get(future));
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.async;
    }

    public Async andThen(Async async, BiConsumer<Row, BoundStatement> biConsumer) {
        async.reset();
        this.inCompletionOrderRows(row -> async.execute(bound -> biConsumer.accept((Row)row, (BoundStatement)bound)));
        return async;
    }
}

