/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.async;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.common.logging.Logger;

public class AsyncFutures<T, D> {
    static Logger logger = Logger.getLogger();
    protected Async async;
    protected List<ListenableFuture<T>> futures;
    protected Map<ListenableFuture<T>, D> futuresData;

    AsyncFutures(Async async, List<ListenableFuture<T>> futures, Map<ListenableFuture<T>, D> futuresData) {
        this.async = async;
        this.futures = futures;
        this.futuresData = futuresData;
    }

    public Async inCompletionOrder() {
        return this.inCompletionOrder(null);
    }

    public Async inCompletionOrder(Consumer<T> consumer) {
        ImmutableList list = Futures.inCompletionOrder(this.futures);
        this.futuresAccept((List<ListenableFuture<T>>)list, consumer);
        return this.async;
    }

    protected void futuresAccept(List<ListenableFuture<T>> list, Consumer consumer) {
        for (ListenableFuture<T> future : list) {
            try {
                Object value = future.get();
                if (consumer == null || value == null) continue;
                consumer.accept(value);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Async inExecutionOrder() {
        return this.inCompletionOrder(null);
    }

    public Async inExecutionOrder(Consumer<T> consumer) {
        this.futuresAccept(this.futures, consumer);
        return this.async;
    }

    public Async inExecutionOrder(BiConsumer<D, T> consumer) {
        for (ListenableFuture<T> future : this.futures) {
            try {
                Object value = future.get();
                if (consumer == null || value == null) continue;
                consumer.accept(this.futuresData.get(future), value);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.async;
    }
}

