/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;

public class Sibyl {
    private static Cache<Class, Inspector> inspectors = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(2000L).build();
    private static Cache<String, PreparedStatement> preparedStatementCache = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).initialCapacity(200).maximumSize(500L).build();
    private Provision provision;
    private Map<Class, Mapper> mappers = new HashMap<Class, Mapper>();
    private boolean saveNullFields = false;

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public Generator getGenerator() {
        return (Generator)this.getProvision().getInstance(Generator.class);
    }

    public Map<Class, Mapper> getMappers() {
        return this.mappers;
    }

    public void setMappers(Map<Class, Mapper> mappers) {
        this.mappers = mappers;
    }

    public Session getSession() {
        return (Session)this.getProvision().open().apply(Resources.class, resources -> (Session)resources.getInstance(Session.class));
    }

    public boolean isSaveNullFields() {
        return this.saveNullFields;
    }

    public void setSaveNullFields(boolean saveNullFields) {
        this.saveNullFields = saveNullFields;
    }

    public Async createAsync() {
        return (Async)this.getProvision().newInstance(Async.class);
    }

    public Async createAsync(String query) {
        PreparedStatement pstmt = null;
        try {
            pstmt = (PreparedStatement)preparedStatementCache.get((Object)query, () -> this.getSession().prepare(query));
        }
        catch (ExecutionException e) {
            pstmt = this.getSession().prepare(query);
        }
        return ((Async)this.getProvision().newInstance(Async.class)).prepare(pstmt);
    }

    public Async createAsync(PreparedStatement stmt) {
        return ((Async)this.getProvision().newInstance(Async.class)).prepare(stmt);
    }

    public <X> AsyncFutures<X, PrimaryKey> get(Collection<PrimaryKey> list, Class<X> cls) {
        Async async = this.createAsync();
        Mapper mapper = this.getMapper(cls);
        mapper.setDefaultGetOptions(new Mapper.Option[]{Mapper.Option.consistencyLevel((ConsistencyLevel)ConsistencyLevel.SERIAL)});
        return async.accept(list, k -> mapper.getAsync(k.getKeys()));
    }

    public <T> Mapper<T> getMapper(Class<T> cls) {
        return this.mappers.computeIfAbsent(cls, key -> ((MappingManager)this.provision.getInstance(MappingManager.class)).mapper(cls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> AsyncFutures<Void, X> save(Collection<X> list, Class<X> cls, Mapper.Option ... options) {
        Async async = this.createAsync();
        Mapper<X> mapper = this.getMapper(cls);
        try {
            if (options != null && options.length > 0) {
                ArrayList<Mapper.Option> all = new ArrayList<Mapper.Option>();
                all.add(Mapper.Option.saveNullFields((boolean)this.isSaveNullFields()));
                for (Mapper.Option option : options) {
                    all.add(option);
                }
                mapper.setDefaultSaveOptions(all.toArray(new Mapper.Option[0]));
            } else {
                mapper.setDefaultSaveOptions(new Mapper.Option[]{Mapper.Option.saveNullFields((boolean)false)});
            }
            AsyncFutures asyncFutures = async.accept(list, arg_0 -> mapper.saveAsync(arg_0));
            return asyncFutures;
        }
        finally {
            mapper.resetDefaultSaveOptions();
        }
    }

    public ResultSet execute(String query, Map<String, Object> map) {
        PreparedStatement pstmt = null;
        try {
            pstmt = (PreparedStatement)preparedStatementCache.get((Object)query, () -> this.getSession().prepare(query));
        }
        catch (ExecutionException e) {
            pstmt = this.getSession().prepare(query);
        }
        return this.execute(pstmt, map);
    }

    public ResultSet execute(PreparedStatement pstmt, Map<String, Object> map) {
        BoundStatement bound = pstmt.bind();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                bound.setToNull(entry.getKey());
                continue;
            }
            bound.set(entry.getKey(), entry.getValue(), entry.getValue().getClass());
        }
        return this.getSession().execute((Statement)bound);
    }

    public <X> X one(Class<X> cls, String query, Map<String, Object> map) {
        ResultSet resultSet = this.execute(query, map);
        Result result = this.getMapper(cls).map(resultSet);
        return (X)result.one();
    }

    public <X> List<X> all(Class<X> cls, String query, Map<String, Object> map) {
        ResultSet resultSet = this.execute(query, map);
        Result result = this.getMapper(cls).map(resultSet);
        return result.all();
    }

    public Inspector getInspector(Class cls) {
        Callable<Inspector> loader = () -> {
            Inspector inspector = new Inspector(cls, this.getGenerator());
            inspector.initialize();
            return inspector;
        };
        try {
            return (Inspector)inspectors.get((Object)cls, loader);
        }
        catch (ExecutionException e) {
            try {
                return loader.call();
            }
            catch (Exception e1) {
                throw new SystemException((Throwable)e);
            }
        }
    }
}

