/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.transmutator;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncResultSet;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.PartitionContext;
import net.e6tech.elements.cassandra.etl.PartitionStrategy;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.cassandra.etl.Strategy;
import net.e6tech.elements.cassandra.transmutator.Loader;
import net.e6tech.elements.common.util.SystemException;

public abstract class Transmutator
implements Strategy<PartitionContext> {
    private LinkedList<Descriptor> descriptors = new LinkedList();

    protected <T> Map<PrimaryKey, T> transform(PartitionContext context, Set<PrimaryKey> keys, Class<T> tableClass) {
        HashMap map = new HashMap();
        context.get(keys, tableClass).inCompletionOrder(item -> {
            if (item != null) {
                map.put(new PrimaryKey(new Object[0]), item);
            }
        });
        return map;
    }

    protected abstract void undo(PartitionContext var1);

    protected void undo(PartitionContext context, Class tableClass) {
        Inspector inspector = context.getInspector(tableClass);
        String tableName = inspector.tableName();
        String partitionKey = inspector.getPartitionKeyColumn(0);
        String checkpointColumn = inspector.getCheckpointColumn(0);
        if (checkpointColumn == null) {
            return;
        }
        String filter = "";
        if (checkpointColumn.equals(partitionKey)) {
            filter = "allow filtering";
        }
        Object value = context.getLastUpdateValue();
        HashSet list = new HashSet();
        AsyncResultSet<?> result = context.createAsync("select " + partitionKey + ", count(*) from " + tableName + " where " + checkpointColumn + " > :spk group by " + partitionKey + " " + filter).execute(bound -> bound.set("spk", value, value.getClass()));
        result.inCompletionOrderRows(row -> {
            if (!row.isNull(0)) {
                list.add(row.get(0, value.getClass()));
            }
        });
        Async async = context.createAsync("delete from " + inspector.tableName() + " where " + partitionKey + " = :partitionKey");
        async.execute(list, (p, bound) -> bound.set("partitionKey", p, p.getClass())).inCompletionOrder();
    }

    protected void analyze() {
        for (Class<?> cls = this.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                Loader loader = method.getAnnotation(Loader.class);
                if (method.getAnnotation(Loader.class) == null) continue;
                if (!method.getReturnType().equals(Integer.TYPE)) {
                    throw new SystemException("Invalid return type for method " + method + ", expecting int");
                }
                if (method.getParameterTypes().length != 2) {
                    throw new SystemException("Invalid number of parameters for method " + method + ", expecting 2");
                }
                Class<?> ptype = method.getParameterTypes()[1];
                if (!ptype.isArray()) {
                    throw new SystemException("Invalid signature for method " + method + ", expecting array type for argument 2.");
                }
                Class<?> componentType = ptype.getComponentType();
                try {
                    PartitionContext context = PartitionContext.createContext(null, componentType);
                    PartitionStrategy strategy = context.createStrategy();
                    context.setExtractorName(componentType.getName() + "_" + this.getClass().getSimpleName());
                    context.setLoadDelegate(list -> {
                        try {
                            return (Integer)method.invoke((Object)this, context, list.toArray((Object[])Array.newInstance(componentType, 0)));
                        }
                        catch (Exception e) {
                            throw new SystemException((Throwable)e);
                        }
                    });
                    Descriptor entry = new Descriptor(loader.value(), context, strategy);
                    this.descriptors.addLast(entry);
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            }
        }
        Collections.sort(this.descriptors, Comparator.comparingInt(p -> p.order));
    }

    protected List<Descriptor> describe() {
        return this.descriptors;
    }

    @Override
    public int run(PartitionContext context) {
        context.setSourceClass(this.getClass());
        this.analyze();
        int count = 0;
        for (Descriptor entry : this.descriptors) {
            entry.context.setStartTime(context.getStartTime());
            entry.context.setProvision(context.getProvision());
            entry.context.setBatchSize(context.getBatchSize());
            entry.context.setExtractAll(context.isExtractAll());
        }
        for (Descriptor entry : this.descriptors) {
            this.undo(entry.context);
        }
        for (Descriptor entry : this.descriptors) {
            try {
                count += entry.strategy.run(entry.context);
            }
            catch (Exception ex) {
                this.undo(entry.context);
                throw ex;
            }
        }
        return count;
    }

    public static class Descriptor {
        int order;
        PartitionContext context;
        PartitionStrategy strategy;

        Descriptor(int order, PartitionContext context, PartitionStrategy strategy) {
            this.order = order;
            this.context = context;
            this.strategy = strategy;
        }
    }
}

