/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Transient;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.cassandra.generator.AbstractGenerator;
import net.e6tech.elements.cassandra.generator.Checkpoint;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.Index;
import net.e6tech.elements.cassandra.generator.Indexes;

public class IndexGenerator
extends AbstractGenerator {
    private Map<String, Checkpoint> implicitIndexes = new LinkedHashMap<String, Checkpoint>();
    private Map<String, String> implicitIndexes2 = new LinkedHashMap<String, String>();
    private Set<String> partitionKeys = new HashSet<String>();
    private Map<String, Index> indexes = new LinkedHashMap<String, Index>();

    IndexGenerator(Generator generator, Class entityClass) throws IntrospectionException {
        super(generator);
        LinkedList<Class> classHierarchy = this.analyze(entityClass);
        for (Class cls : classHierarchy) {
            Indexes indexList = cls.getAnnotation(Indexes.class);
            if (indexList == null) continue;
            for (Index index : indexList.value()) {
                if (index.name().isEmpty()) {
                    this.indexes.put(index.column() + "_idx", index);
                    continue;
                }
                this.indexes.put(index.name(), index);
            }
        }
        for (Class cls : classHierarchy) {
            Field[] fields = cls.getDeclaredFields();
            for (Field field : fields) {
                if (Modifier.isStrict(field.getModifiers())) continue;
                Column column = field.getAnnotation(Column.class);
                Transient trans = field.getAnnotation(Transient.class);
                if (trans != null) continue;
                PartitionKey pk = field.getAnnotation(PartitionKey.class);
                if (pk != null) {
                    this.partitionKeys.add(generator.getColumnName(column, field));
                    this.partitionKeys.add(field.getName());
                    continue;
                }
                Checkpoint lastUpdateBy = field.getAnnotation(Checkpoint.class);
                if (lastUpdateBy == null) continue;
                this.implicitIndexes.put(generator.getColumnName(column, field), lastUpdateBy);
                this.implicitIndexes2.put(field.getName(), generator.getColumnName(column, field));
            }
        }
        for (PropertyDescriptor desc : Introspector.getBeanInfo(entityClass).getPropertyDescriptors()) {
            Checkpoint lastUpdateBy;
            Transient trans;
            Method method = null;
            if (desc.getReadMethod() != null) {
                method = desc.getReadMethod();
            }
            Column column = method.getAnnotation(Column.class);
            if (method == null || method.getName().equals("getClass") || (trans = method.getAnnotation(Transient.class)) != null) continue;
            PartitionKey pk = method.getAnnotation(PartitionKey.class);
            if (pk != null) {
                this.partitionKeys.add(generator.getColumnName(column, method));
                this.partitionKeys.add(desc.getName());
                continue;
            }
            if (this.partitionKeys.contains(desc.getName()) || this.partitionKeys.contains(generator.getColumnName(column, method)) || (lastUpdateBy = method.getAnnotation(Checkpoint.class)) == null) continue;
            this.implicitIndexes.remove(generator.getColumnName(column, method));
            String columnName = this.implicitIndexes2.get(desc.getName());
            this.implicitIndexes.remove(columnName);
            this.implicitIndexes.put(generator.getColumnName(column, method), lastUpdateBy);
        }
    }

    public List<String> generate() {
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Index> entry : this.indexes.entrySet()) {
            Index index = entry.getValue();
            builder.append("CREATE INDEX IF NOT EXISTS ");
            builder.append(this.getTable().name()).append("__").append(entry.getKey());
            builder.append(" ON ");
            builder.append(this.fullyQualifiedTableName());
            builder.append("(");
            if (index.keys()) {
                builder.append("KEYS(");
            }
            builder.append(index.column());
            if (index.keys()) {
                builder.append(")");
            }
            builder.append(")");
            statements.add(builder.toString());
            builder.setLength(0);
        }
        for (String column : this.implicitIndexes.keySet()) {
            builder.append("CREATE CUSTOM INDEX IF NOT EXISTS ");
            builder.append(this.getTable().name()).append("__").append(column).append("_idx");
            builder.append(" ON ");
            builder.append(this.fullyQualifiedTableName());
            builder.append("(");
            builder.append(column);
            builder.append(") USING 'org.apache.cassandra.index.sasi.SASIIndex' WITH OPTIONS = {'mode' : 'SPARSE'} ");
            statements.add(builder.toString());
            builder.setLength(0);
        }
        return statements;
    }
}

