/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import com.datastax.driver.mapping.NamingStrategy;
import com.datastax.driver.mapping.annotations.Column;
import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.e6tech.elements.cassandra.generator.Codec;
import net.e6tech.elements.cassandra.generator.CodecGenerator;
import net.e6tech.elements.cassandra.generator.IndexGenerator;
import net.e6tech.elements.cassandra.generator.TableGenerator;
import net.e6tech.elements.common.util.SystemException;

public class Generator {
    private Map<String, Class> dataNames = new HashMap<String, Class>();
    private Map<Type, String> dataTypes = new HashMap<Type, String>();
    private NamingStrategy namingStrategy;

    public Generator() {
        this.dataTypes.put((Type)((Object)Boolean.class), "boolean");
        this.dataTypes.put(Boolean.TYPE, "boolean");
        this.dataTypes.put((Type)((Object)Long.class), "bigint");
        this.dataTypes.put(Long.TYPE, "bigint");
        this.dataTypes.put((Type)((Object)Integer.class), "int");
        this.dataTypes.put(Integer.TYPE, "int");
        this.dataTypes.put((Type)((Object)BigDecimal.class), "decimal");
        this.dataTypes.put((Type)((Object)Double.class), "double");
        this.dataTypes.put(Double.TYPE, "double");
        this.dataTypes.put((Type)((Object)Float.class), "float");
        this.dataTypes.put(Float.TYPE, "float");
        this.dataTypes.put((Type)((Object)String.class), "text");
        this.dataTypes.put((Type)((Object)UUID.class), "uuid");
        this.dataTypes.put((Type)((Object)byte[].class), "blob");
        this.dataNames.put("boolean", Boolean.class);
        this.dataNames.put("bigint", Long.class);
        this.dataNames.put("int", Integer.class);
        this.dataNames.put("decimal", BigDecimal.class);
        this.dataNames.put("double", Double.class);
        this.dataNames.put("float", Float.class);
        this.dataNames.put("text", String.class);
        this.dataNames.put("uuid", UUID.class);
        this.dataNames.put("blob", byte[].class);
    }

    public String createTable(String keyspace, Class cls) {
        TableGenerator gen = null;
        try {
            gen = new TableGenerator(this, cls);
            gen.setKeyspace(keyspace);
        }
        catch (IntrospectionException e) {
            throw new SystemException((Throwable)e);
        }
        return gen.generate();
    }

    public List<String> createIndexes(String keyspace, Class cls) {
        IndexGenerator gen = null;
        try {
            gen = new IndexGenerator(this, cls);
            gen.setKeyspace(keyspace);
        }
        catch (IntrospectionException e) {
            throw new SystemException((Throwable)e);
        }
        return gen.generate();
    }

    public String createCodecs(String keyspace, String userType, Class<? extends Codec> codecClass) {
        CodecGenerator gen = new CodecGenerator(this, userType, codecClass);
        gen.setKeyspace(keyspace);
        return gen.generate();
    }

    public String getDataType(Type type) {
        return this.dataTypes.get(type);
    }

    public void setDataType(Type type, String dataType) {
        this.dataTypes.put(type, dataType);
        if (type instanceof Class) {
            this.dataNames.put(dataType, (Class)type);
        }
    }

    public Object getDataValue(String type, String value) {
        Class cls = this.dataNames.get(type);
        if (UUID.class.equals((Object)cls)) {
            return UUID.fromString(value);
        }
        if (byte[].class.isAssignableFrom(cls)) {
            throw new UnsupportedOperationException("byte[] is not supported");
        }
        try {
            return cls.getDeclaredConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public String toCassandraName(String javaPropertyName) {
        return this.namingStrategy.toCassandraName(javaPropertyName);
    }

    public String getColumnName(Column column, Field field) {
        String columnName = column == null || column.name().isEmpty() ? this.toCassandraName(field.getName()) : column.name();
        return columnName;
    }

    public String getColumnName(Column column, Method method) {
        String columnName;
        if (column == null || column.name().isEmpty()) {
            String name = method.getName();
            if (name.startsWith("is")) {
                name = name.substring(2);
            } else if (name.startsWith("set") || name.startsWith("get")) {
                name = name.substring(3);
            }
            columnName = this.toCassandraName(name);
        } else {
            columnName = column.name();
        }
        return columnName;
    }
}

