/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.ListType;
import net.e6tech.elements.cassandra.generator.MapType;
import net.e6tech.elements.cassandra.generator.SetType;
import net.e6tech.elements.cassandra.generator.TypeDescriptor;

public class DataType {
    private boolean frozen;
    private Type type;
    private Generator generator;
    private boolean timeBased;

    public static DataType create(Generator generator, Type type, TypeDescriptor typeDescriptor) {
        Class cls = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        if (Map.class.isAssignableFrom(cls)) {
            return new MapType(generator, type, typeDescriptor);
        }
        if (List.class.isAssignableFrom(cls)) {
            return new ListType(generator, type, typeDescriptor);
        }
        if (Set.class.isAssignableFrom(cls)) {
            return new SetType(generator, type, typeDescriptor);
        }
        return new DataType(generator, type, typeDescriptor);
    }

    public DataType(Generator generator, Type type, TypeDescriptor typeDescriptor) {
        this.generator = generator;
        this.type = type;
        this.frozen = typeDescriptor.isFrozen();
        this.timeBased = typeDescriptor.isTimeBased();
    }

    public boolean getFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type instanceof Class && Enum.class.isAssignableFrom((Class)this.type)) {
            if (this.frozen) {
                return "frozen<text>";
            }
            return "text";
        }
        String cqlType = this.generator.getDataType(this.type);
        if (this.timeBased && cqlType.equalsIgnoreCase("uuid")) {
            cqlType = "timeuuid";
        }
        if (this.frozen) {
            return "frozen<" + cqlType + ">";
        }
        return cqlType;
    }
}

