/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.generator;

import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Frozen;
import com.datastax.driver.mapping.annotations.FrozenKey;
import com.datastax.driver.mapping.annotations.FrozenValue;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.cassandra.generator.TimeBased;
import net.e6tech.elements.cassandra.generator.TypeDescriptor;

public class AnnotatedTypeDescriptor
implements TypeDescriptor {
    private AnnotatedTypeDescriptor parent;
    private AccessibleObject annotated;
    private String columnName;

    public AnnotatedTypeDescriptor(Generator generator, Field field) {
        this.annotated = field;
        this.columnName = generator.getColumnName(this.annotated.getAnnotation(Column.class), field);
    }

    public AnnotatedTypeDescriptor(Generator generator, Method method, AnnotatedTypeDescriptor parent) {
        this.annotated = method;
        this.columnName = generator.getColumnName(this.annotated.getAnnotation(Column.class), method);
        this.parent = parent;
    }

    @Override
    public boolean isFrozen() {
        if (this.annotated.getAnnotation(Frozen.class) != null) {
            return this.annotated.getAnnotation(Frozen.class) != null;
        }
        if (this.parent != null) {
            return this.parent.isFrozen();
        }
        return false;
    }

    @Override
    public boolean isFrozenKey() {
        if (this.annotated.getAnnotation(FrozenKey.class) != null) {
            return this.annotated.getAnnotation(FrozenKey.class) != null;
        }
        if (this.parent != null) {
            return this.parent.isFrozenKey();
        }
        return false;
    }

    @Override
    public boolean isFrozenValue() {
        if (this.annotated.getAnnotation(FrozenValue.class) != null) {
            return this.annotated.getAnnotation(FrozenValue.class) != null;
        }
        if (this.parent != null) {
            return this.parent.isFrozenValue();
        }
        return false;
    }

    @Override
    public boolean isTimeBased() {
        if (this.annotated.getAnnotation(TimeBased.class) != null) {
            return this.annotated.getAnnotation(TimeBased.class) != null;
        }
        if (this.parent != null) {
            return this.parent.isTimeBased();
        }
        return false;
    }

    @Override
    public String getColumnName() {
        if (this.annotated.getAnnotation(Column.class) != null) {
            return this.columnName;
        }
        if (this.parent != null && this.parent.annotated.getAnnotation(Column.class) != null) {
            return this.parent.getColumnName();
        }
        return this.columnName;
    }
}

