/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.etl.ETLContext;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.datastructure.Pair;

public class Transform<T, E> {
    private Map<PrimaryKey, T> map = new HashMap<PrimaryKey, T>();
    private Class<T> tableClass;
    private ETLContext context;
    private Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    private List<Pair<PrimaryKey, E>> entries = new ArrayList<Pair<PrimaryKey, E>>();

    public Transform(ETLContext context, Class<T> cls) {
        this.context = context;
        this.tableClass = cls;
    }

    public Transform<T, E> addPrimaryKey(PrimaryKey key, E e) {
        if (key == null) {
            return this;
        }
        this.primaryKeys.add(key);
        this.entries.add(new Pair((Object)key, e));
        return this;
    }

    public Transform<T, E> load() {
        this.context.get(this.keys(), this.tableClass).inExecutionOrder(this.map::put);
        return this;
    }

    public Set<PrimaryKey> keys() {
        return this.primaryKeys;
    }

    public Collection<Pair<PrimaryKey, E>> entries() {
        return this.entries;
    }

    public Transform<T, E> put(PrimaryKey key, T t) {
        this.map.put(key, t);
        return this;
    }

    public T computeIfAbsent(PrimaryKey key) {
        return this.computeIfAbsent(key, null);
    }

    public T computeIfAbsent(PrimaryKey key, Consumer<T> consumer) {
        return (T)this.map.computeIfAbsent(key, (? super K k) -> {
            try {
                T t = this.tableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.context.setPrimaryKey(key, t);
                if (consumer != null) {
                    consumer.accept(t);
                    this.context.setPrimaryKey(key, t);
                }
                return t;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        });
    }

    public Transform<T, E> forEachCreateIfNotExist(BiConsumer<E, T> consumer) {
        for (Pair<PrimaryKey, E> e : this.entries()) {
            T t = this.computeIfAbsent((PrimaryKey)e.key());
            consumer.accept(e.value(), t);
            this.checkpoint(e.value(), t);
        }
        return this;
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public Set<PrimaryKey> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public void checkpoint(E extraction, T t) {
        Object extractionKey = this.context.getInspector(extraction.getClass()).getPartitionKey(extraction, 0);
        if (extractionKey == null) {
            return;
        }
        this.context.getInspector(this.tableClass).setCheckpoint(t, 0, extractionKey);
    }
}

