/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.List;
import net.e6tech.elements.cassandra.etl.BatchStrategy;
import net.e6tech.elements.cassandra.etl.LastUpdate;
import net.e6tech.elements.cassandra.etl.TimeBatch;

public interface TimeBatchStrategy<S>
extends BatchStrategy<S, TimeBatch> {
    @Override
    default public List<S> extract(TimeBatch context) {
        LastUpdate lastUpdate = context.getLastUpdate();
        List<S> list = this.extractUpdate(context, lastUpdate);
        context.saveLastUpdate(lastUpdate);
        return list;
    }

    public List<S> extractUpdate(TimeBatch var1, LastUpdate var2);

    @Override
    default public int run(TimeBatch context) {
        if (context.getSourceClass() == null) {
            throw new IllegalStateException("sourceClass not set in context");
        }
        context.initialize();
        LastUpdate lastUpdate = context.getLastUpdate();
        long lastImport = new Long(lastUpdate.getLastUpdate());
        long start = System.currentTimeMillis();
        context.setEnd(start - context.getTimeLag());
        context.setStart(lastImport);
        int importedCount = 0;
        List<S> batchResults = null;
        logger.info("Loading Class {}", this.getClass());
        while (!(batchResults = this.extract(context)).isEmpty()) {
            int processedCount = this.load(context, batchResults);
            logger.info("Processed {} instance of {}", (Object)processedCount, this.getClass());
            importedCount += processedCount;
        }
        logger.info("Done loading {} instance of {}", (Object)importedCount, this.getClass());
        return importedCount;
    }
}

