/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.cassandra.etl.PartitionContext;
import net.e6tech.elements.cassandra.etl.PartitionOrderBy;
import net.e6tech.elements.cassandra.etl.PrimaryKey;

public class PartitionOrderByMap<T extends PartitionOrderBy> {
    private Map<Comparable, List<T>> partitionMap = new LinkedHashMap<Comparable, List<T>>();
    private Map<Comparable, List<PrimaryKey>> primaryKeys = new LinkedHashMap<Comparable, List<PrimaryKey>>();
    private PartitionContext context;

    public PartitionOrderByMap(PartitionContext context) {
        this.context = context;
    }

    public PartitionOrderByMap<T> addAll(Collection<T> objects) {
        List list;
        for (PartitionOrderBy partitionOrderBy : objects) {
            list = this.partitionMap.computeIfAbsent((Comparable)this.context.getInspector().getPartitionKey(partitionOrderBy, 0), key -> new ArrayList());
            list.add(partitionOrderBy);
        }
        for (List list2 : this.partitionMap.values()) {
            Collections.sort(list2, Comparator.comparing(t -> (Comparable)this.context.getInspector().getClusteringKey(t, 0)));
        }
        for (Map.Entry entry : this.partitionMap.entrySet()) {
            list = this.primaryKeys.computeIfAbsent((Comparable)entry.getKey(), (Function<Comparable, List<PrimaryKey>>)((Function<Comparable, List>)key -> new ArrayList()));
            for (PartitionOrderBy t2 : (List)entry.getValue()) {
                list.add(this.context.getPrimaryKey(t2));
            }
        }
        return this;
    }

    public PartitionOrderByMap<T> getValueList(Comparable partitionKey, Consumer<List<T>> consumer) {
        List<T> list = this.partitionMap.get(partitionKey);
        if (list != null) {
            consumer.accept(list);
        }
        return this;
    }

    public PartitionOrderByMap<T> getPrimaryKeyList(Comparable partitionKey, Consumer<List<PrimaryKey>> consumer) {
        List<PrimaryKey> list = this.primaryKeys.get(partitionKey);
        if (list != null) {
            consumer.accept(list);
        }
        return this;
    }

    public PartitionOrderByMap<T> forEachValueList(BiConsumer<Comparable, List<T>> consumer) {
        for (Map.Entry<Comparable, List<T>> entry : this.partitionMap.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public PartitionOrderByMap<T> forEachPrimaryKeyList(BiConsumer<Comparable, List<PrimaryKey>> consumer) {
        for (Map.Entry<Comparable, List<PrimaryKey>> entry : this.primaryKeys.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public PartitionOrderByMap<T> forEachValue(Consumer<T> consumer) {
        for (Map.Entry<Comparable, List<T>> entry : this.partitionMap.entrySet()) {
            for (PartitionOrderBy t : entry.getValue()) {
                consumer.accept(t);
            }
        }
        return this;
    }

    public PartitionOrderByMap<T> forEachPrimaryKey(Consumer<PrimaryKey> consumer) {
        for (Map.Entry<Comparable, List<PrimaryKey>> entry : this.primaryKeys.entrySet()) {
            for (PrimaryKey t : entry.getValue()) {
                consumer.accept(t);
            }
        }
        return this;
    }
}

