/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.etl;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.async.Async;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.etl.Inspector;
import net.e6tech.elements.cassandra.etl.LastUpdate;
import net.e6tech.elements.cassandra.etl.PrimaryKey;
import net.e6tech.elements.cassandra.etl.Transform;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.UnitOfWork;

public class ETLContext {
    public static final long DAY = 86400000L;
    public static final long HOUR = 3600000L;
    public static final long MINUTE = 60000L;
    public static final long SECOND = 60000L;
    public static final long MONTH = 2592000000L;
    public static final long TIME_LAG = 300000L;
    public static final int BATCH_SIZE = 1000;
    private Provision provision;
    private int batchSize = 1000;
    private long timeLag = 300000L;
    private int importedCount;
    private String extractorName;
    private boolean extractAll = true;
    private Class sourceClass;
    private TimeUnit timeUnit;
    private boolean initialized = false;
    private long startTime = System.currentTimeMillis();
    private Sibyl sibyl;
    private Class<LastUpdate> lastUpdateClass;
    private LastUpdate lastUpdate;

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
        if (provision != null) {
            this.sibyl = (Sibyl)provision.getInstance(Sibyl.class);
        }
    }

    public Generator getGenerator() {
        return (Generator)this.getProvision().getInstance(Generator.class);
    }

    public UnitOfWork open() {
        return this.getProvision().open();
    }

    public Session getSession() {
        return (Session)this.getProvision().open().apply(Resources.class, resources -> (Session)resources.getInstance(Session.class));
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getTimeLag() {
        return this.timeLag;
    }

    public void setTimeLag(long timeLag) {
        this.timeLag = timeLag;
    }

    public int getImportedCount() {
        return this.importedCount;
    }

    public void setImportedCount(int importedCount) {
        this.importedCount = importedCount;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isExtractAll() {
        return this.extractAll;
    }

    public void setExtractAll(boolean extractAll) {
        this.extractAll = extractAll;
    }

    public <T> Mapper<T> getMapper(Class<T> cls) {
        return this.sibyl.getMapper(cls);
    }

    public String getExtractorName() {
        return this.extractorName;
    }

    public void setExtractorName(String extractorName) {
        this.extractorName = extractorName;
    }

    public String extractor() {
        return this.getExtractorName() != null ? this.getExtractorName() : this.getSourceClass().getName();
    }

    public Class<LastUpdate> getLastUpdateClass() {
        return this.lastUpdateClass;
    }

    public void setLastUpdateClass(Class<LastUpdate> lastUpdateClass) {
        this.lastUpdateClass = lastUpdateClass;
    }

    public Class getPartitionKeyType() {
        this.initialize();
        return this.getInspector(this.getSourceClass()).getPartitionKeyClass(0);
    }

    public void reset() {
    }

    public TimeUnit getTimeUnit() {
        String partitionKeyColumn;
        this.initialize();
        if (this.timeUnit == null && (partitionKeyColumn = this.getInspector(this.getSourceClass()).getPartitionKeyColumn(0)) != null) {
            this.timeUnit = partitionKeyColumn.endsWith("_day") ? TimeUnit.DAYS : (partitionKeyColumn.endsWith("_hour") ? TimeUnit.HOURS : (partitionKeyColumn.endsWith("_minute") ? TimeUnit.MINUTES : (partitionKeyColumn.endsWith("_second") ? TimeUnit.SECONDS : (partitionKeyColumn.endsWith("_milli") ? TimeUnit.MILLISECONDS : (partitionKeyColumn.endsWith("_time") ? TimeUnit.MILLISECONDS : null)))));
        }
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Async createAsync() {
        return (Async)this.getProvision().newInstance(Async.class);
    }

    public Async createAsync(String query) {
        return ((Async)this.getProvision().newInstance(Async.class)).prepare(query);
    }

    public Async createAsync(PreparedStatement stmt) {
        return ((Async)this.getProvision().newInstance(Async.class)).prepare(stmt);
    }

    public <X> AsyncFutures<Void, X> save(Collection<X> list, Class<X> cls, Mapper.Option ... options) {
        Sibyl s = (Sibyl)this.provision.getInstance(Sibyl.class);
        return s.save(list, cls, options);
    }

    public <X> AsyncFutures<X, PrimaryKey> get(Collection<PrimaryKey> list, Class<X> cls) {
        Sibyl s = (Sibyl)this.provision.getInstance(Sibyl.class);
        return s.get(list, cls);
    }

    public <T, E> Transform<T, E> transform(E[] array, Class<T> targetClass, BiConsumer<Transform<T, E>, E> consumer) {
        Transform keyMap = new Transform(this, targetClass);
        for (E e : array) {
            consumer.accept(keyMap, e);
        }
        return keyMap.load();
    }

    public PrimaryKey getPrimaryKey(Object instance) {
        return this.getInspector(instance.getClass()).getPrimaryKey(instance);
    }

    public void setPrimaryKey(PrimaryKey key, Object instance) {
        this.getInspector(instance.getClass()).setPrimaryKey(key, instance);
    }

    public String tableName() {
        return this.getInspector(this.getSourceClass()).tableName();
    }

    public void saveLastUpdate(LastUpdate lastUpdate) {
        if (this.lastUpdateClass == null) {
            this.lastUpdateClass = (Class)this.getProvision().open().apply(Resources.class, resources -> ((SessionProvider)resources.getInstance(SessionProvider.class)).getLastUpdateClass());
        }
        this.getMapper(this.lastUpdateClass).save((Object)lastUpdate);
        this.lastUpdate = lastUpdate;
    }

    public LastUpdate lookupLastUpdate() {
        if (this.lastUpdate != null) {
            return this.lastUpdate;
        }
        if (this.lastUpdateClass == null) {
            this.lastUpdateClass = (Class)this.getProvision().open().apply(Resources.class, resources -> ((SessionProvider)resources.getInstance(SessionProvider.class)).getLastUpdateClass());
        }
        this.lastUpdate = (LastUpdate)this.open().apply(Resources.class, resources -> (LastUpdate)((MappingManager)resources.getInstance(MappingManager.class)).mapper(this.lastUpdateClass).get(new Object[]{this.extractor()}));
        return this.lastUpdate;
    }

    public LastUpdate getLastUpdate() {
        String name = this.extractor();
        this.lookupLastUpdate();
        if (this.lastUpdate == null) {
            this.lastUpdate = new LastUpdate();
            this.lastUpdate.setExtractor(name);
            if (this.extractAll) {
                if (UUID.class.isAssignableFrom(this.getPartitionKeyType())) {
                    this.lastUpdate.setLastUpdate(new UUID(Long.MIN_VALUE, Long.MIN_VALUE).toString());
                } else {
                    this.lastUpdate.setLastUpdate("0");
                }
            } else {
                this.lastUpdate.setLastUpdate("" + this.cutoffOrUpdate(false));
            }
            this.lastUpdate.setDataType(this.getGenerator().getDataType(this.getPartitionKeyType()));
            if (this.getTimeUnit() != null) {
                this.lastUpdate.setUnit(this.getTimeUnit().toString());
            } else {
                this.lastUpdate.setUnit("1");
            }
        }
        return this.lastUpdate;
    }

    public Object getLastUpdateValue() {
        LastUpdate l = this.getLastUpdate();
        return this.getGenerator().getDataValue(l.getDataType(), l.getLastUpdate());
    }

    public Comparable getCutoff() {
        return this.cutoffOrUpdate(true);
    }

    private Comparable cutoffOrUpdate(boolean cutoff) {
        if (TimeUnit.DAYS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf(this.startTime / 86400000L);
        }
        if (TimeUnit.HOURS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf(this.startTime / 3600000L);
        }
        if (TimeUnit.MINUTES.equals((Object)this.getTimeUnit())) {
            return Long.valueOf(this.startTime / 60000L);
        }
        if (TimeUnit.SECONDS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf(this.startTime / 60000L);
        }
        if (TimeUnit.MILLISECONDS.equals((Object)this.getTimeUnit())) {
            return Long.valueOf(this.startTime);
        }
        if (cutoff) {
            if (UUID.class.isAssignableFrom(this.getPartitionKeyType())) {
                return new UUID(Long.MAX_VALUE, Long.MAX_VALUE);
            }
            return Long.valueOf(Long.MAX_VALUE);
        }
        if (UUID.class.isAssignableFrom(this.getPartitionKeyType())) {
            return new UUID(Long.MIN_VALUE, Long.MIN_VALUE);
        }
        return Long.valueOf(0L);
    }

    public Inspector getInspector() {
        return this.getInspector(this.getSourceClass());
    }

    public Inspector getInspector(Class cls) {
        return ((Sibyl)this.provision.getInstance(Sibyl.class)).getInspector(cls);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Inspector inspector = this.getInspector(this.getSourceClass());
        if (this.timeUnit == null) {
            this.timeUnit = inspector.getTimeUnit();
        }
    }
}

