/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra.async;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.cassandra.async.AsyncFutures;
import net.e6tech.elements.cassandra.async.AsyncResultSet;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Provision;

public class Async {
    private static Cache<String, PreparedStatement> preparedStatementCache = CacheBuilder.newBuilder().concurrencyLevel(Provision.cacheBuilderConcurrencyLevel.intValue()).initialCapacity(200).maximumSize(500L).build();
    private PreparedStatement preparedStatement;
    private List<ListenableFuture> futures = Lists.newArrayList();
    private Map<ListenableFuture, Object> futuresData = new IdentityHashMap<ListenableFuture, Object>();
    private Session session;
    private AsyncResultSet result = new AsyncResultSet(this, (List<ResultSetFuture>)this.futures, (Map<ResultSetFuture, Object>)this.futuresData);
    private Provision provision;

    public static void resetAll(Async ... asyncs) {
        if (asyncs != null) {
            for (Async async : asyncs) {
                async.reset();
            }
        }
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
        this.session = (Session)provision.getInstance(Session.class);
    }

    public Async prepare(String stmt) {
        try {
            return this.prepare((PreparedStatement)preparedStatementCache.get((Object)stmt, () -> this.session.prepare(stmt)));
        }
        catch (ExecutionException e) {
            return this.prepare(this.session.prepare(stmt));
        }
    }

    public Async prepare(PreparedStatement stmt) {
        this.preparedStatement = stmt;
        return this;
    }

    public Async reset() {
        this.futures.clear();
        this.futuresData.clear();
        return this;
    }

    public <T, D> AsyncFutures<T, D> getResult() {
        return this.result;
    }

    public <T, D> AsyncFutures<T, D> acceptAll(AsyncFutures<T, D> result) {
        for (ListenableFuture future : result.futures) {
            this.futures.add(future);
            if (!result.futuresData.containsKey(future)) continue;
            this.futuresData.put(future, result.futuresData.get(future));
        }
        return result;
    }

    public <T, D> AsyncFutures<T, D> accept(D data, ListenableFuture<T> future) {
        this.futures.add(future);
        if (data != null) {
            this.futuresData.put(future, data);
        }
        return this.result;
    }

    public <T, D> AsyncFutures<T, D> accept(Iterable<D> iterable, Function<D, ListenableFuture<T>> function) {
        for (D t : iterable) {
            this.accept(t, function.apply(t));
        }
        return this.result;
    }

    public AsyncResultSet<?> execute(Consumer<BoundStatement> consumer) {
        return this.execute(null, consumer);
    }

    public <D> AsyncResultSet<D> execute(D data, Consumer<BoundStatement> consumer) {
        BoundStatement bound = this.preparedStatement.bind();
        consumer.accept(bound);
        ResultSetFuture future = this.session.executeAsync((Statement)bound);
        this.futures.add((ListenableFuture)future);
        if (data != null) {
            this.futuresData.put((ListenableFuture)future, data);
        }
        return this.result;
    }

    public <D> AsyncResultSet<D> execute(Iterable<D> iterable, BiConsumer<D, BoundStatement> biConsumer) {
        for (Object t : iterable) {
            this.execute(t, (BoundStatement boundStatement) -> biConsumer.accept(t, (BoundStatement)boundStatement));
        }
        return this.result;
    }

    public <D> AsyncResultSet<D> execute(D[] array, BiConsumer<D, BoundStatement> biConsumer) {
        for (Object t : array) {
            this.execute(t, (BoundStatement boundStatement) -> biConsumer.accept(t, (BoundStatement)boundStatement));
        }
        return new AsyncResultSet(this, (List<ResultSetFuture>)this.futures, (Map<ResultSetFuture, Object>)this.futuresData);
    }

    public Async inCompletionOrder() {
        return this.inCompletionOrder(null);
    }

    public <T> Async inCompletionOrder(Consumer<T> consumer) {
        this.result.inCompletionOrder(consumer);
        return this;
    }

    public Async inExecutionOrder() {
        return this.inExecutionOrder((Consumer)null);
    }

    public <T> Async inExecutionOrder(Consumer<T> consumer) {
        return this.result.inExecutionOrder(consumer);
    }

    public <D, T> Async inExecutionOrder(BiConsumer<D, T> consumer) {
        return this.result.inExecutionOrder(consumer);
    }
}

