/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.mapping.DefaultNamingStrategy;
import com.datastax.driver.mapping.DefaultPropertyMapper;
import com.datastax.driver.mapping.MappingConfiguration;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.NamingConventions;
import com.datastax.driver.mapping.NamingStrategy;
import com.datastax.driver.mapping.PropertyMapper;
import com.datastax.driver.mapping.annotations.UDT;
import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.cassandra.Sibyl;
import net.e6tech.elements.cassandra.etl.LastUpdate;
import net.e6tech.elements.cassandra.generator.Generator;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.ResourceProvider;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;

public class SessionProvider
implements ResourceProvider,
Initializable {
    private Cluster cluster;
    private String host;
    private int port = 9042;
    private String keyspace;
    private Map<String, Session> sessions = new HashMap<String, Session>();
    private Provision provision;
    private Map<String, MappingManager> mappingManager = new HashMap<String, MappingManager>();
    private Generator generator = new Generator();
    private int coreConnections = 20;
    private int maxConnections = 200;
    private int maxRequests = 32768;
    private HostDistance distance = HostDistance.LOCAL;
    private NamingStrategy namingStrategy = new DefaultNamingStrategy(NamingConventions.LOWER_CAMEL_CASE, NamingConventions.LOWER_SNAKE_CASE);
    private Class<? extends LastUpdate> lastUpdateClass = LastUpdate.class;
    private boolean saveNullFields = false;

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public int getCoreConnections() {
        return this.coreConnections;
    }

    public void setCoreConnections(int coreConnections) {
        this.coreConnections = coreConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public HostDistance getDistance() {
        return this.distance;
    }

    public void setDistance(HostDistance distance) {
        this.distance = distance;
    }

    public Session getSession() {
        return this.getSession(this.keyspace);
    }

    public Session getSession(String keyspaceIn) {
        String ks = keyspaceIn;
        if (ks == null) {
            ks = this.keyspace;
        }
        return this.sessions.computeIfAbsent(ks, this::buildSession);
    }

    public MappingManager getMappingManager() {
        return this.getMappingManager(this.keyspace);
    }

    public MappingManager getMappingManager(String keyspaceIn) {
        return this.mappingManager.computeIfAbsent(keyspaceIn, key -> {
            DefaultPropertyMapper propertyMapper = new DefaultPropertyMapper();
            propertyMapper.setNamingStrategy(this.namingStrategy);
            MappingConfiguration conf = MappingConfiguration.builder().withPropertyMapper((PropertyMapper)propertyMapper).build();
            return new MappingManager(this.getSession(keyspaceIn), conf);
        });
    }

    public boolean isSaveNullFields() {
        return this.saveNullFields;
    }

    public void setSaveNullFields(boolean saveNullFields) {
        this.saveNullFields = saveNullFields;
    }

    public Class<? extends LastUpdate> getLastUpdateClass() {
        return this.lastUpdateClass;
    }

    public void setLastUpdateClass(Class<? extends LastUpdate> lastUpdateClass) {
        this.lastUpdateClass = lastUpdateClass;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    protected synchronized Session buildSession(String keyspaceIn) {
        return this.sessions.computeIfAbsent(keyspaceIn, key -> this.getCluster().connect(keyspaceIn));
    }

    protected synchronized void buildCluster() {
        if (this.cluster != null) {
            return;
        }
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, this.coreConnections).setMaxConnectionsPerHost(HostDistance.LOCAL, this.maxConnections).setMaxRequestsPerConnection(HostDistance.LOCAL, this.maxRequests);
        this.cluster = Cluster.builder().addContactPoint(this.host).withPort(this.port).withPoolingOptions(poolingOptions).build();
    }

    public void initialize(Resources resources) {
        this.generator.setNamingStrategy(this.namingStrategy);
        this.provision.getResourceManager().bind(Generator.class, (Object)this.generator);
        if (this.cluster != null) {
            return;
        }
        this.buildCluster();
        try {
            this.getSession();
        }
        catch (InvalidQueryException ex) {
            Session session = this.getCluster().connect();
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE KEYSPACE IF NOT EXISTS ").append(this.keyspace);
            sb.append(" WITH replication = {'class':'SimpleStrategy', 'replication_factor' : 1};");
            session.execute(sb.toString());
            session.close();
            this.getSession();
        }
        this.getMappingManager();
        this.provision.getResourceManager().rebind(Session.class, (Object)this.getSession());
        this.provision.getResourceManager().rebind(MappingManager.class, (Object)this.getMappingManager());
        this.provision.getResourceManager().rebind(Cluster.class, (Object)this.getCluster());
        this.provision.getResourceManager().rebind(SessionProvider.class, (Object)this);
        Sibyl sibyl = (Sibyl)this.provision.newInstance(Sibyl.class);
        sibyl.setSaveNullFields(this.isSaveNullFields());
        this.provision.getResourceManager().rebind(Sibyl.class, (Object)sibyl);
    }

    public void registerCodec(Class<? extends TypeCodec> codecClass) {
        UDT udt = codecClass.getAnnotation(UDT.class);
        if (udt == null) {
            throw new IllegalArgumentException("Codec class does not have @UDT annotation");
        }
        this.registerCodec(udt.keyspace(), udt.name(), codecClass);
    }

    public void registerCodec(String keyspaceIn, String userType, Class<? extends TypeCodec> codecClass) {
        try {
            if (keyspaceIn == null || keyspaceIn.isEmpty()) {
                keyspaceIn = this.keyspace;
            }
            CodecRegistry codecRegistry = this.cluster.getConfiguration().getCodecRegistry();
            UserType type = this.cluster.getMetadata().getKeyspace(keyspaceIn).getUserType(userType);
            if (type == null) {
                throw new SystemException("Invalid user type " + userType + " in keyspace " + this.keyspace);
            }
            TypeCodec userTypeCodec = codecRegistry.codecFor((DataType)type);
            TypeCodec typeCodec = codecClass.getConstructor(TypeCodec.class, Class.class).newInstance(userTypeCodec, Reflection.getParametrizedType(codecClass, (int)0));
            codecRegistry.register(typeCodec);
            this.generator.setDataType(Reflection.getParametrizedType(codecClass, (int)0), userType);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void onOpen(Resources resources) {
    }

    public void afterOpen(Resources resources) {
    }

    public void onCommit(Resources resources) {
    }

    public void afterCommit(Resources resources) {
    }

    public void afterAbort(Resources resources) {
    }

    public void onAbort(Resources resources) {
    }

    public void onClosed(Resources resources) {
    }

    public void onShutdown() {
    }

    public String getDescription() {
        return null;
    }
}

