/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.mapping.annotations.Table;
import com.datastax.driver.mapping.annotations.UDT;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.e6tech.elements.cassandra.SessionProvider;
import net.e6tech.elements.cassandra.etl.ETLContext;
import net.e6tech.elements.cassandra.etl.Strategy;
import net.e6tech.elements.cassandra.generator.Codec;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.PackageScanner;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.StringUtil;
import net.e6tech.elements.common.util.SystemException;

public class Schema {
    private static Cache<String, List<String>> scriptCache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).maximumSize(1000L).build();
    private static Logger logger = Logger.getLogger();
    private Provision provision;
    private List<Map<String, String>> codecs = new ArrayList<Map<String, String>>();

    public List<Map<String, String>> getCodecs() {
        return this.codecs;
    }

    public void setCodecs(List<Map<String, String>> codecs) {
        this.codecs = codecs;
    }

    public SessionProvider getProvider(Resources resources) {
        return (SessionProvider)resources.getInstance(SessionProvider.class);
    }

    public void createCodecs(String keyspace, String userType, Class<? extends Codec> codec) {
        this.provision.open().accept(Resources.class, resources -> {
            String cql = this.getProvider((Resources)resources).getGenerator().createCodecs(keyspace, userType, codec);
            try {
                this.getProvider((Resources)resources).getSession(keyspace).execute(cql);
                logger.info("Created UDT type " + userType + " for class " + codec);
            }
            catch (SyntaxError ex) {
                logger.info("Syntax error in creating table for " + codec);
                logger.info(cql);
                throw ex;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCodecs(String keyspace, String packageName, Class ... order) {
        try {
            this.provision.suppressLogging();
            this.provision.open().accept(Resources.class, resources -> {
                Class[] found;
                SessionProvider provider = this.getProvider((Resources)resources);
                Class[] classes = found = packageName == null ? new Class[]{} : this.scanClasses(UDT.class, packageName);
                if (order != null) {
                    ArrayList<Class> list = new ArrayList<Class>();
                    for (Class cls : found) {
                        for (Class cls2 : order) {
                            if (cls.equals(cls2)) continue;
                            list.add(cls);
                        }
                    }
                    Class[] classArray = order;
                    int n = classArray.length;
                    for (int i = 0; i < n; ++i) {
                        Class cls;
                        cls = classArray[i];
                        list.add(cls);
                    }
                    classes = list.toArray(new Class[0]);
                }
                for (Class codecClass : classes) {
                    try {
                        String keySpaceIn = null;
                        String userType = null;
                        UDT udt = codecClass.getAnnotation(UDT.class);
                        if (!udt.keyspace().isEmpty()) {
                            keySpaceIn = udt.keyspace();
                        }
                        userType = udt.name();
                        if (keyspace != null) {
                            keySpaceIn = keyspace;
                        }
                        if (Codec.class.isAssignableFrom(codecClass)) {
                            this.createCodecs(keySpaceIn, userType, codecClass);
                        }
                        provider.registerCodec(keySpaceIn, userType, codecClass);
                    }
                    catch (SyntaxError e) {
                        logger.warn("Cannot register codec for class " + codecClass.getName());
                    }
                }
            });
        }
        finally {
            this.provision.resumeLogging();
        }
    }

    public void registerCodecs() {
        this.provision.open().accept(Resources.class, resources -> {
            SessionProvider provider = this.getProvider((Resources)resources);
            for (Map<String, String> map : this.codecs) {
                String codecClassName = map.get("codec");
                if (codecClassName == null) {
                    throw new IllegalArgumentException("No codec defined");
                }
                try {
                    Class<?> codecClass = this.getClass().getClassLoader().loadClass(codecClassName);
                    String keySpaceIn = null;
                    String userType = null;
                    UDT udt = codecClass.getAnnotation(UDT.class);
                    if (udt != null) {
                        if (!udt.keyspace().isEmpty()) {
                            keySpaceIn = udt.keyspace();
                        }
                        userType = udt.name();
                    }
                    if (map.get("keyspace") != null) {
                        keySpaceIn = map.get("keyspace");
                    }
                    if (map.get("userType") != null) {
                        userType = map.get("userType");
                    }
                    if (userType == null) {
                        throw new IllegalArgumentException("No userType defined");
                    }
                    if (Codec.class.isAssignableFrom(codecClass)) {
                        this.createCodecs(keySpaceIn, userType, codecClass);
                    }
                    provider.registerCodec(keySpaceIn, userType, codecClass);
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            }
        });
    }

    public void createKeyspace(String keyspaceIn, int replication) {
        this.provision.open().accept(Resources.class, resources -> {
            Metadata meta = ((Cluster)resources.getInstance(Cluster.class)).getMetadata();
            if (meta.getKeyspace(keyspaceIn) == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE KEYSPACE IF NOT EXISTS ").append(keyspaceIn);
                sb.append(" WITH replication = {'class':'SimpleStrategy', 'replication_factor' : " + replication + "};");
                ((Session)resources.getInstance(Session.class)).execute(sb.toString());
            }
        });
    }

    private <A extends Annotation> Class[] scanClasses(Class<A> annotationClass, String ... packageNames) {
        if (packageNames == null || packageNames.length == 0) {
            return new Class[0];
        }
        PackageScanner packageScanner = new PackageScanner();
        ArrayList<Class> list = new ArrayList<Class>();
        for (String packageName : packageNames) {
            Class[] classes;
            for (Class cls : classes = packageScanner.getTopLevelClassesRecursive(this.getClass().getClassLoader(), packageName)) {
                if (cls.getAnnotation(annotationClass) == null) continue;
                list.add(cls);
            }
        }
        return list.toArray(new Class[0]);
    }

    public void createTables(String keyspace, String ... packageNames) {
        Class[] classes = this.scanClasses(Table.class, packageNames);
        this.createTables(keyspace, classes);
    }

    public void createTables(String keyspace, Class ... classes) {
        this.provision.open().accept(Resources.class, resources -> {
            for (Class cls : classes) {
                String cql = this.getProvider((Resources)resources).getGenerator().createTable(keyspace, cls);
                try {
                    this.getProvider((Resources)resources).getSession(keyspace).execute(cql);
                }
                catch (Exception ex) {
                    logger.info("Syntax error in creating table for " + cls);
                    logger.info(cql);
                    throw ex;
                }
            }
            for (Class cls : classes) {
                List<String> statements = this.getProvider((Resources)resources).getGenerator().createIndexes(keyspace, cls);
                for (String cql : statements) {
                    try {
                        this.getProvider((Resources)resources).getSession(keyspace).execute(cql);
                    }
                    catch (Exception ex) {
                        logger.info("Syntax error in creating index for " + cls);
                        logger.info(cql);
                        throw ex;
                    }
                }
            }
        });
    }

    public void runScripts(ScriptType type, Class ... classes) {
        this.provision.open().accept(Resources.class, resources -> {
            for (Class cls : classes) {
                List<String> statements = Schema.getScript(cls, type);
                for (String stmt : statements) {
                    ((Session)resources.getInstance(Session.class)).execute(stmt);
                }
            }
        });
    }

    public void runScripts(String keyspace, ScriptType type, Class ... classes) {
        this.provision.open().accept(Resources.class, resources -> {
            for (Class cls : classes) {
                List<String> statements = Schema.getScript(cls, type);
                for (String stmt : statements) {
                    this.getProvider((Resources)resources).getSession(keyspace).execute(stmt);
                }
            }
        });
    }

    public static List<String> getScript(Class cls, ScriptType type) {
        String tmp = "";
        if (type != null) {
            tmp = "_" + type.name();
        }
        String postfix = tmp;
        try {
            return (List)scriptCache.get((Object)(cls.getName() + postfix), () -> {
                try (BufferedInputStream stream = new BufferedInputStream(cls.getResourceAsStream(cls.getSimpleName() + postfix + ".cql"));){
                    int size;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((size = stream.read(buffer)) != -1) {
                        output.write(buffer, 0, size);
                    }
                    String file = new String(output.toByteArray(), StandardCharsets.UTF_8);
                    String[] statments = file.split(";");
                    ArrayList<String> list = new ArrayList<String>();
                    for (String stmt : statments) {
                        if (StringUtil.isNullOrEmpty((String)stmt)) continue;
                        list.add(stmt);
                    }
                    List list2 = Collections.unmodifiableList(list);
                    return list2;
                }
            });
        }
        catch (ExecutionException e) {
            logger.error("Cannot retrieve script " + cls.getSimpleName() + postfix + ".cql");
            throw new SystemException((Throwable)e);
        }
    }

    public void extract(String packageName) {
        this.extract(packageName, false);
    }

    public void extractRecursive(String packageName) {
        this.extract(packageName, true);
    }

    public void extract(String packageName, boolean recursive) {
        this.extract(packageName, recursive, null);
    }

    public void extract(String packageName, boolean recursive, Consumer<ETLContext> customizer) {
        Class[] classes;
        PackageScanner scanner = new PackageScanner();
        ArrayList<Class> classList = new ArrayList<Class>();
        for (Class clazz : classes = recursive ? scanner.getTopLevelClassesRecursive(Strategy.class.getClassLoader(), packageName) : scanner.getTopLevelClasses(Strategy.class.getClassLoader(), packageName)) {
            if (!Strategy.class.isAssignableFrom(clazz)) continue;
            classList.add(clazz);
        }
        LinkedHashMap map = new LinkedHashMap();
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) continue;
            list.clear();
            for (Class clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                this.analyze(clazz2, list);
            }
            if (list.isEmpty()) continue;
            map.put(clazz, list.get(0));
        }
        for (Map.Entry entry : map.entrySet()) {
            ETLContext context = null;
            try {
                context = (ETLContext)this.provision.newInstance((Class)entry.getValue());
                if (customizer != null) {
                    customizer.accept(context);
                }
                Strategy strategy = (Strategy)((Class)entry.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                strategy.run(context);
            }
            catch (Exception exception) {
                logger.error("Cannot extract {}", entry.getKey());
                throw new SystemException((Throwable)exception);
            }
        }
    }

    private void analyze(Class cls, List<Class> list) {
        if (Strategy.class.isAssignableFrom(cls)) {
            block0: for (TypeVariable typeVar : cls.getTypeParameters()) {
                for (Type t : typeVar.getBounds()) {
                    if (!(t instanceof Class) || !ETLContext.class.isAssignableFrom((Class)t)) continue;
                    list.add((Class)t);
                    continue block0;
                }
            }
            Type sup = cls.getGenericSuperclass();
            if (sup instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)sup;
                for (Type arg : ptype.getActualTypeArguments()) {
                    if (!(arg instanceof Class) || !ETLContext.class.isAssignableFrom((Class)arg)) continue;
                    list.add((Class)arg);
                }
            }
            for (Type type : cls.getGenericInterfaces()) {
                ParameterizedType ptype;
                if (!(type instanceof ParameterizedType) || !Strategy.class.isAssignableFrom((Class)(ptype = (ParameterizedType)type).getRawType())) continue;
                for (Type arg : ptype.getActualTypeArguments()) {
                    if (!(arg instanceof Class) || !ETLContext.class.isAssignableFrom((Class)arg)) continue;
                    list.add((Class)arg);
                }
                this.analyze((Class)ptype.getRawType(), list);
            }
        }
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public static enum ScriptType {
        create,
        extract;

    }
}

