/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.provider;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.hypixel.entities.CurrencyType;
import net.dungeonhub.hypixel.entities.DungeonType;
import net.dungeonhub.hypixel.entities.EssenceType;
import net.dungeonhub.hypixel.entities.KnownCurrencyTypes;
import net.dungeonhub.hypixel.entities.KnownDungeonType;
import net.dungeonhub.hypixel.entities.KnownEssenceType;
import net.dungeonhub.hypixel.entities.KnownPetItem;
import net.dungeonhub.hypixel.entities.KnownSkill;
import net.dungeonhub.hypixel.entities.KnownSlayerType;
import net.dungeonhub.hypixel.entities.PetItem;
import net.dungeonhub.hypixel.entities.Skill;
import net.dungeonhub.hypixel.entities.SkyblockProfileMember;
import net.dungeonhub.hypixel.entities.SlayerType;
import net.dungeonhub.hypixel.entities.player.KnownRank;
import net.dungeonhub.hypixel.entities.player.KnownSocialMediaType;
import net.dungeonhub.hypixel.entities.player.Rank;
import net.dungeonhub.hypixel.entities.player.SocialMediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\r\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lnet/dungeonhub/provider/GsonProvider;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "PolymorphDeserializer", "PetItemSerializer", "RankSerializer", "SocialMediaTypeSerializer", "SkillSerializer", "SlayerTypeSerializer", "CurrencySerializer", "DungeonTypeSerializer", "EssenceTypeSerializer", "JsonType", "JsonSubtype", "SuperClassExclusionStrategies", "InstantTypeAdapter", "hypixel-wrapper"})
public final class GsonProvider {
    @NotNull
    public static final GsonProvider INSTANCE = new GsonProvider();
    @NotNull
    private static final Gson gson;

    private GsonProvider() {
    }

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    static {
        ExclusionStrategy[] exclusionStrategyArray = new ExclusionStrategy[]{new SuperClassExclusionStrategies(SkyblockProfileMember.class)};
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Instant.class), (Object)new InstantTypeAdapter()).registerTypeAdapter((Type)((Object)SkyblockProfileMember.class), new PolymorphDeserializer()).registerTypeAdapter((Type)((Object)KnownPetItem.class), (Object)new PetItemSerializer()).registerTypeAdapter((Type)((Object)PetItem.class), (Object)new PetItemSerializer()).registerTypeAdapter((Type)((Object)KnownSkill.class), (Object)new SkillSerializer()).registerTypeAdapter((Type)((Object)Skill.class), (Object)new SkillSerializer()).registerTypeAdapter((Type)((Object)KnownCurrencyTypes.class), (Object)new CurrencySerializer()).registerTypeAdapter((Type)((Object)CurrencyType.class), (Object)new CurrencySerializer()).registerTypeAdapter((Type)((Object)KnownDungeonType.class), (Object)new DungeonTypeSerializer()).registerTypeAdapter((Type)((Object)DungeonType.class), (Object)new DungeonTypeSerializer()).registerTypeAdapter((Type)((Object)KnownEssenceType.class), (Object)new EssenceTypeSerializer()).registerTypeAdapter((Type)((Object)EssenceType.class), (Object)new EssenceTypeSerializer()).registerTypeAdapter((Type)((Object)KnownSlayerType.class), (Object)new SlayerTypeSerializer()).registerTypeAdapter((Type)((Object)SlayerType.class), (Object)new SlayerTypeSerializer()).registerTypeAdapter((Type)((Object)KnownSocialMediaType.class), (Object)new SocialMediaTypeSerializer()).registerTypeAdapter((Type)((Object)SocialMediaType.class), (Object)new SocialMediaTypeSerializer()).registerTypeAdapter((Type)((Object)KnownRank.class), (Object)new RankSerializer()).registerTypeAdapter((Type)((Object)Rank.class), (Object)new RankSerializer()).enableComplexMapKeySerialization().setExclusionStrategies(exclusionStrategyArray).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GsonProvider.gson = gson;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$CurrencySerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/CurrencyType;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class CurrencySerializer
    implements JsonSerializer<CurrencyType>,
    JsonDeserializer<CurrencyType> {
        @NotNull
        public JsonElement serialize(@NotNull CurrencyType src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public CurrencyType deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            JsonElement jsonElement = json;
            Intrinsics.checkNotNull((Object)jsonElement);
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownCurrencyTypes.Companion.toCurrencyType(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$DungeonTypeSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/DungeonType;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class DungeonTypeSerializer
    implements JsonSerializer<DungeonType>,
    JsonDeserializer<DungeonType> {
        @NotNull
        public JsonElement serialize(@NotNull DungeonType src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public DungeonType deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            JsonElement jsonElement = json;
            Intrinsics.checkNotNull((Object)jsonElement);
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownDungeonType.Companion.fromApiName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$EssenceTypeSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/EssenceType;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class EssenceTypeSerializer
    implements JsonSerializer<EssenceType>,
    JsonDeserializer<EssenceType> {
        @NotNull
        public JsonElement serialize(@NotNull EssenceType src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public EssenceType deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            JsonElement jsonElement = json;
            Intrinsics.checkNotNull((Object)jsonElement);
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownEssenceType.Companion.fromApiName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/dungeonhub/provider/GsonProvider$InstantTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Ljava/time/Instant;", "<init>", "()V", "write", "", "jsonWriter", "Lcom/google/gson/stream/JsonWriter;", "instant", "read", "jsonReader", "Lcom/google/gson/stream/JsonReader;", "hypixel-wrapper"})
    private static final class InstantTypeAdapter
    extends TypeAdapter<Instant> {
        public void write(@NotNull JsonWriter jsonWriter, @Nullable Instant instant) throws IOException {
            Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
            if (instant == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(instant.toEpochMilli());
        }

        @Nullable
        public Instant read(@NotNull JsonReader jsonReader) throws IOException {
            Intrinsics.checkNotNullParameter((Object)jsonReader, (String)"jsonReader");
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return Instant.ofEpochMilli(jsonReader.nextLong());
        }
    }

    @java.lang.annotation.Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0002\u0018\u00002\u00020\u0001B\u0014\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005R\u0013\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0006R\u000f\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/dungeonhub/provider/GsonProvider$JsonSubtype;", "", "clazz", "Lkotlin/reflect/KClass;", "name", "", "()Ljava/lang/Class;", "()Ljava/lang/String;", "hypixel-wrapper"})
    public static @interface JsonSubtype {
        public Class<?> clazz();

        public String name();
    }

    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.CLASS})
    @Retention(value=AnnotationRetention.RUNTIME)
    @java.lang.annotation.Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u000f\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0007R\u0015\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\t"}, d2={"Lnet/dungeonhub/provider/GsonProvider$JsonType;", "", "property", "", "subtypes", "", "Lnet/dungeonhub/provider/GsonProvider$JsonSubtype;", "()Ljava/lang/String;", "()[Lnet/dungeonhub/provider/GsonProvider$JsonSubtype;", "hypixel-wrapper"})
    public static @interface JsonType {
        public String property();

        public JsonSubtype[] subtypes();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$PetItemSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/PetItem;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class PetItemSerializer
    implements JsonSerializer<PetItem>,
    JsonDeserializer<PetItem> {
        @NotNull
        public JsonElement serialize(@NotNull PetItem src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public PetItem deserialize(@NotNull JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string = json.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownPetItem.Companion.fromApiName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lnet/dungeonhub/provider/GsonProvider$PolymorphDeserializer;", "T", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Ljava/lang/Object;", "hypixel-wrapper"})
    private static final class PolymorphDeserializer<T>
    implements JsonDeserializer<T> {
        public T deserialize(@NotNull JsonElement json, @NotNull Type type, @NotNull JsonDeserializationContext context) throws JsonParseException {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                Class<?> typeClass = Class.forName(type.getTypeName());
                JsonType jsonType = typeClass.getDeclaredAnnotation(JsonType.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonType, (String)"getDeclaredAnnotation(...)");
                JsonType jsonType2 = jsonType;
                String property = json.getAsJsonObject().get(jsonType2.property()).getAsString();
                JsonSubtype[] subtypes = jsonType2.subtypes();
                Class<?> subType = ((JsonSubtype)Arrays.stream(subtypes).filter(arg_0 -> PolymorphDeserializer.deserialize$lambda$1(arg_0 -> PolymorphDeserializer.deserialize$lambda$0(property, arg_0), arg_0)).findFirst().orElseThrow(PolymorphDeserializer::deserialize$lambda$2)).clazz();
                return (T)context.deserialize(json, (Type)subType);
            }
            catch (Exception e) {
                throw new JsonParseException("Failed deserialize json", (Throwable)e);
            }
        }

        private static final boolean deserialize$lambda$0(String $property, JsonSubtype subtype) {
            Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
            return Intrinsics.areEqual((Object)subtype.name(), (Object)$property);
        }

        private static final boolean deserialize$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final IllegalArgumentException deserialize$lambda$2() {
            return new IllegalArgumentException();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$RankSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/player/Rank;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class RankSerializer
    implements JsonSerializer<Rank>,
    JsonDeserializer<Rank> {
        @NotNull
        public JsonElement serialize(@NotNull Rank src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public Rank deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            JsonElement jsonElement = json;
            Intrinsics.checkNotNull((Object)jsonElement);
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownRank.Companion.fromApiName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$SkillSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/Skill;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class SkillSerializer
    implements JsonSerializer<Skill>,
    JsonDeserializer<Skill> {
        @NotNull
        public JsonElement serialize(@NotNull Skill src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public Skill deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            JsonElement jsonElement = json;
            Intrinsics.checkNotNull((Object)jsonElement);
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownSkill.Companion.fromApiName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$SlayerTypeSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/SlayerType;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class SlayerTypeSerializer
    implements JsonSerializer<SlayerType>,
    JsonDeserializer<SlayerType> {
        @NotNull
        public JsonElement serialize(@NotNull SlayerType src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public SlayerType deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            JsonElement jsonElement = json;
            Intrinsics.checkNotNull((Object)jsonElement);
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownSlayerType.Companion.fromApiName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/provider/GsonProvider$SocialMediaTypeSerializer;", "Lcom/google/gson/JsonSerializer;", "Lnet/dungeonhub/hypixel/entities/player/SocialMediaType;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "hypixel-wrapper"})
    private static final class SocialMediaTypeSerializer
    implements JsonSerializer<SocialMediaType>,
    JsonDeserializer<SocialMediaType> {
        @NotNull
        public JsonElement serialize(@NotNull SocialMediaType src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (JsonElement)new JsonPrimitive(src.getApiName());
        }

        @NotNull
        public SocialMediaType deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
            JsonElement jsonElement = json;
            Intrinsics.checkNotNull((Object)jsonElement);
            String string = jsonElement.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return KnownSocialMediaType.Companion.fromApiName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/provider/GsonProvider$SuperClassExclusionStrategies;", "Lcom/google/gson/ExclusionStrategy;", "typeToSkip", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "shouldSkipClass", "", "clazz", "shouldSkipField", "f", "Lcom/google/gson/FieldAttributes;", "hypixel-wrapper"})
    private static final class SuperClassExclusionStrategies
    implements ExclusionStrategy {
        @NotNull
        private final Class<?> typeToSkip;

        public SuperClassExclusionStrategies(@NotNull Class<?> typeToSkip) {
            Intrinsics.checkNotNullParameter(typeToSkip, (String)"typeToSkip");
            this.typeToSkip = typeToSkip;
        }

        public boolean shouldSkipClass(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return false;
        }

        public boolean shouldSkipField(@NotNull FieldAttributes f) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            return Intrinsics.areEqual((Object)f.getDeclaringClass(), this.typeToSkip) && !Intrinsics.areEqual((Object)f.getName(), (Object)"type");
        }
    }
}

