/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.mojang.connection;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.dungeonhub.cache.memory.CacheElement;
import net.dungeonhub.cache.memory.HashMapCache;
import net.dungeonhub.exception.PlayerNotFoundException;
import net.dungeonhub.mojang.entity.Player;
import net.dungeonhub.mojang.entity.PlayerKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lnet/dungeonhub/mojang/connection/MojangConnection;", "", "<init>", "()V", "EXPIRATION_TIME", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "cache", "Lnet/dungeonhub/cache/memory/HashMapCache;", "Lnet/dungeonhub/mojang/entity/Player;", "Ljava/util/UUID;", "getCache", "()Lnet/dungeonhub/cache/memory/HashMapCache;", "getHttpClient", "Lokhttp3/OkHttpClient;", "getUUIDByName", "name", "", "getNameByUUID", "uuid", "hypixel-wrapper"})
@SourceDebugExtension(value={"SMAP\nMojangConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MojangConnection.kt\nnet/dungeonhub/mojang/connection/MojangConnection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n295#2,2:107\n295#2,2:109\n*S KotlinDebug\n*F\n+ 1 MojangConnection.kt\nnet/dungeonhub/mojang/connection/MojangConnection\n*L\n35#1:107,2\n72#1:109,2\n*E\n"})
public final class MojangConnection {
    @NotNull
    public static final MojangConnection INSTANCE = new MojangConnection();
    private static final long EXPIRATION_TIME = 10800L;
    private static final Logger logger = LoggerFactory.getLogger(MojangConnection.class);
    @NotNull
    private static final HashMapCache<Player, UUID> cache = new HashMapCache(MojangConnection::cache$lambda$0);

    private MojangConnection() {
    }

    @NotNull
    public final HashMapCache<Player, UUID> getCache() {
        return cache;
    }

    @NotNull
    public final OkHttpClient getHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(true);
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder2 = builder.connectTimeout(duration);
        Duration duration2 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder3 = builder2.readTimeout(duration2);
        Duration duration3 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder4 = builder3.callTimeout(duration3);
        Duration duration4 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
        return builder4.writeTimeout(duration4).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UUID getUUIDByName(@NotNull String name) throws PlayerNotFoundException {
        Object v1;
        block12: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = cache.retrieveAllElements();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                CacheElement playerElement = (CacheElement)element$iv;
                boolean bl2 = false;
                if (playerElement.getTimeAdded().isBefore(Instant.now().minusSeconds(10800L))) {
                    cache.invalidateEntry(((Player)playerElement.getValue()).getId());
                    bl = false;
                } else {
                    bl = StringsKt.equals((String)((Player)playerElement.getValue()).getName(), (String)name, (boolean)true);
                }
                if (!bl) continue;
                v1 = element$iv;
                break block12;
            }
            v1 = null;
        }
        CacheElement cachedEntry = v1;
        if (cachedEntry != null) {
            return ((Player)cachedEntry.getValue()).getId();
        }
        Request request = new Request.Builder().url("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + name).get().build();
        try {
            Object object;
            Closeable $i$f$firstOrNull;
            block13: {
                $i$f$firstOrNull = (Closeable)this.getHttpClient().newCall(request).execute();
                object = null;
                Response response = (Response)$i$f$firstOrNull;
                boolean bl = false;
                if (!response.isSuccessful() || response.body() == null) break block13;
                ResponseBody responseBody = response.body();
                Intrinsics.checkNotNull((Object)responseBody);
                JsonObject jsonObject = JsonParser.parseString((String)responseBody.string()).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                Player player = PlayerKt.toPlayer(jsonObject);
                cache.store(player);
                UUID uUID = player.getId();
                CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, (Throwable)object);
                return uUID;
            }
            try {
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, object);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, (Throwable)object);
        }
        catch (IOException exception) {
            logger.error(null, (Throwable)exception);
        }
        catch (NullPointerException exception) {
            logger.error(null, (Throwable)exception);
        }
        throw new PlayerNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getNameByUUID(@NotNull UUID uuid) throws PlayerNotFoundException {
        Object v1;
        block12: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable $this$firstOrNull$iv = cache.retrieveAllElements();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                CacheElement playerElement = (CacheElement)element$iv;
                boolean bl2 = false;
                if (playerElement.getTimeAdded().isBefore(Instant.now().minusSeconds(10800L))) {
                    cache.invalidateEntry(((Player)playerElement.getValue()).getId());
                    bl = false;
                } else {
                    bl = Intrinsics.areEqual((Object)((Player)playerElement.getValue()).getId(), (Object)uuid);
                }
                if (!bl) continue;
                v1 = element$iv;
                break block12;
            }
            v1 = null;
        }
        CacheElement cachedEntry = v1;
        if (cachedEntry != null) {
            return ((Player)cachedEntry.getValue()).getName();
        }
        Request request = new Request.Builder().url("https://api.minecraftservices.com/minecraft/profile/lookup/" + uuid).get().build();
        try {
            Object object;
            Closeable $i$f$firstOrNull;
            block13: {
                $i$f$firstOrNull = (Closeable)this.getHttpClient().newCall(request).execute();
                object = null;
                Response response = (Response)$i$f$firstOrNull;
                boolean bl = false;
                if (!response.isSuccessful() || response.body() == null) break block13;
                ResponseBody responseBody = response.body();
                Intrinsics.checkNotNull((Object)responseBody);
                JsonObject jsonObject = JsonParser.parseString((String)responseBody.string()).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                Player player = PlayerKt.toPlayer(jsonObject);
                cache.store(player);
                String string = player.getName();
                CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, (Throwable)object);
                return string;
            }
            try {
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, object);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)$i$f$firstOrNull, (Throwable)object);
        }
        catch (IOException exception) {
            logger.error(null, (Throwable)exception);
        }
        catch (NullPointerException exception) {
            logger.error(null, (Throwable)exception);
        }
        throw new PlayerNotFoundException(uuid);
    }

    private static final UUID cache$lambda$0(Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }
}

