/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.service;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lnet/dungeonhub/hypixel/service/FormattingService;", "", "<init>", "()V", "makeDoubleReadable", "", "number", "", "maxFractionDigits", "", "locale", "Ljava/util/Locale;", "makeNumberReadable", "", "hypixel-wrapper"})
public final class FormattingService {
    @NotNull
    public static final FormattingService INSTANCE = new FormattingService();

    private FormattingService() {
    }

    @NotNull
    public final String makeDoubleReadable(double number, int maxFractionDigits, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(locale));
        df.setMaximumFractionDigits(maxFractionDigits);
        String string = df.format(number);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static /* synthetic */ String makeDoubleReadable$default(FormattingService formattingService, double d, int n, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 340;
        }
        if ((n2 & 4) != 0) {
            locale = Locale.US;
        }
        return formattingService.makeDoubleReadable(d, n, locale);
    }

    @NotNull
    public final String makeNumberReadable(long number, int maxFractionDigits) {
        if (number >= 1000000000000L) {
            return FormattingService.makeDoubleReadable$default(this, (double)number / 1.0E12, maxFractionDigits, null, 4, null) + "t";
        }
        if (number >= 1000000000L) {
            return FormattingService.makeDoubleReadable$default(this, (double)number / 1.0E9, maxFractionDigits, null, 4, null) + "b";
        }
        if (number >= 1000000L) {
            return FormattingService.makeDoubleReadable$default(this, (double)number / 1000000.0, maxFractionDigits, null, 4, null) + "m";
        }
        if (number >= 1000L) {
            return FormattingService.makeDoubleReadable$default(this, (double)number / 1000.0, maxFractionDigits, null, 4, null) + "k";
        }
        return String.valueOf(number);
    }

    public static /* synthetic */ String makeNumberReadable$default(FormattingService formattingService, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 340;
        }
        return formattingService.makeNumberReadable(l, n);
    }
}

