/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.entities.inventory;

import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.nullicorn.nedit.type.NBTCompound;
import net.dungeonhub.hypixel.entities.Pet;
import net.dungeonhub.hypixel.entities.PetKt;
import net.dungeonhub.hypixel.entities.inventory.ItemGemsData;
import net.dungeonhub.hypixel.entities.inventory.ItemGemsDataKt;
import net.dungeonhub.hypixel.entities.inventory.ItemStack;
import net.dungeonhub.provider.GsonProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001d0'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001d0'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0013\u0010,\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\tR\u0011\u0010.\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001fR\u0011\u00100\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001fR\u0011\u00102\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0017R\u0011\u00104\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u001fR\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001d\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001d0'8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010)\u00a8\u0006<"}, d2={"Lnet/dungeonhub/hypixel/entities/inventory/SkyblockItem;", "Lnet/dungeonhub/hypixel/entities/inventory/ItemStack;", "raw", "Lme/nullicorn/nedit/type/NBTCompound;", "<init>", "(Lme/nullicorn/nedit/type/NBTCompound;)V", "id", "", "getId", "()Ljava/lang/String;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "originTag", "getOriginTag", "timestamp", "Ljava/time/Instant;", "getTimestamp", "()Ljava/time/Instant;", "rarityUpgraded", "", "getRarityUpgraded", "()Z", "museumDonated", "getMuseumDonated", "etherWarp", "getEtherWarp", "transmissionTuners", "", "getTransmissionTuners", "()I", "manaDisintegrators", "getManaDisintegrators", "gems", "Lnet/dungeonhub/hypixel/entities/inventory/ItemGemsData;", "getGems", "()Lnet/dungeonhub/hypixel/entities/inventory/ItemGemsData;", "enchantments", "", "getEnchantments", "()Ljava/util/Map;", "runes", "getRunes", "reforge", "getReforge", "starAmount", "getStarAmount", "hotPotatoes", "getHotPotatoes", "dungeonItem", "getDungeonItem", "anvilUses", "getAnvilUses", "petInfo", "Lnet/dungeonhub/hypixel/entities/Pet;", "getPetInfo", "()Lnet/dungeonhub/hypixel/entities/Pet;", "attributes", "getAttributes", "hypixel-wrapper"})
@SourceDebugExtension(value={"SMAP\nSkyblockItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkyblockItem.kt\nnet/dungeonhub/hypixel/entities/inventory/SkyblockItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1#2:89\n462#3:90\n412#3:91\n462#3:96\n412#3:97\n462#3:102\n412#3:103\n1246#4,4:92\n1246#4,4:98\n1246#4,4:104\n*S KotlinDebug\n*F\n+ 1 SkyblockItem.kt\nnet/dungeonhub/hypixel/entities/inventory/SkyblockItem\n*L\n50#1:90\n50#1:91\n55#1:96\n55#1:97\n78#1:102\n78#1:103\n50#1:92,4\n55#1:98,4\n78#1:104,4\n*E\n"})
public final class SkyblockItem
extends ItemStack {
    public SkyblockItem(@NotNull NBTCompound raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        super(raw);
    }

    @NotNull
    public final String getId() {
        String string = this.getExtraAttributes().getString("id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @Nullable
    public final UUID getUuid() {
        UUID uUID;
        String string = this.getExtraAttributes().getString("uuid");
        if (string != null) {
            String it = string;
            boolean bl = false;
            uUID = UUID.fromString(it);
        } else {
            uUID = null;
        }
        return uUID;
    }

    @Nullable
    public final String getOriginTag() {
        return this.getExtraAttributes().getString("originTag");
    }

    @Nullable
    public final Instant getTimestamp() {
        Instant instant;
        Long l = this.getExtraAttributes().getLong("timestamp", -1L);
        long it = ((Number)l).longValue();
        boolean bl = false;
        Long l2 = it != -1L ? l : null;
        if (l2 != null) {
            it = ((Number)l2).longValue();
            boolean bl2 = false;
            instant = Instant.ofEpochMilli(it);
        } else {
            instant = null;
        }
        return instant;
    }

    public final boolean getRarityUpgraded() {
        return this.getExtraAttributes().getInt("rarity_upgrades", 0) == 1;
    }

    public final boolean getMuseumDonated() {
        return this.getExtraAttributes().getByte("donated_museum", (byte)0) == 1;
    }

    public final boolean getEtherWarp() {
        return this.getExtraAttributes().getByte("ethermerge", (byte)0) == 1;
    }

    public final int getTransmissionTuners() {
        return this.getExtraAttributes().getInt("tuned_transmission", 0);
    }

    public final int getManaDisintegrators() {
        return this.getExtraAttributes().getInt("mana_disintegrator_count", 0);
    }

    @Nullable
    public final ItemGemsData getGems() {
        NBTCompound nBTCompound = this.getExtraAttributes().getCompound("gems");
        return nBTCompound != null ? ItemGemsDataKt.toGemsData(nBTCompound) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getEnchantments() {
        Map map;
        NBTCompound nBTCompound = this.getExtraAttributes().getCompound("enchantments");
        if (nBTCompound != null) {
            void $this$mapValuesTo$iv$iv;
            NBTCompound it = nBTCompound;
            boolean bl = false;
            Map $this$mapValues$iv = (Map)it;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void enchantment;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                Object v = enchantment.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Int");
                Integer n = (int)((Integer)v);
                map4.put(k, n);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getRunes() {
        Map map;
        NBTCompound nBTCompound = this.getExtraAttributes().getCompound("runes");
        if (nBTCompound != null) {
            void $this$mapValuesTo$iv$iv;
            NBTCompound it = nBTCompound;
            boolean bl = false;
            Map $this$mapValues$iv = (Map)it;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void rune;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                Object v = rune.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Int");
                Integer n = (int)((Integer)v);
                map4.put(k, n);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    public final String getReforge() {
        return this.getExtraAttributes().getString("modifier");
    }

    public final int getStarAmount() {
        return this.getExtraAttributes().getInt("upgrade_level", 0);
    }

    public final int getHotPotatoes() {
        return this.getExtraAttributes().getInt("hot_potato_count", 0);
    }

    public final boolean getDungeonItem() {
        return this.getExtraAttributes().getByte("dungeon_item", (byte)-1) == 1;
    }

    public final int getAnvilUses() {
        return this.getExtraAttributes().getInt("anvil_uses", 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Pet getPetInfo() {
        String string = this.getExtraAttributes().getString("petInfo");
        String string2 = string;
        if (string == null) return null;
        String it = string2;
        boolean bl = false;
        JsonObject jsonObject = (JsonObject)GsonProvider.INSTANCE.getGson().fromJson(it, JsonObject.class);
        string2 = jsonObject;
        if (jsonObject == null) return null;
        Pet pet = PetKt.toPet((JsonObject)string2);
        return pet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getAttributes() {
        Map map;
        NBTCompound nBTCompound = this.getExtraAttributes().getCompound("attributes");
        if (nBTCompound != null) {
            void $this$mapValuesTo$iv$iv;
            NBTCompound it = nBTCompound;
            boolean bl = false;
            Map $this$mapValues$iv = (Map)it;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void attribute;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                Object v = attribute.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Int");
                Integer n = (int)((Integer)v);
                map4.put(k, n);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }
}

