/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.connection;

import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientJvmKt;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.exception.FailedToLoadException;
import net.hypixel.api.HypixelAPI;
import net.hypixel.api.http.HypixelHttpClient;
import net.hypixel.api.http.HypixelHttpResponse;
import net.hypixel.api.http.RateLimit;
import net.hypixel.api.reply.StatusReply;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lnet/dungeonhub/hypixel/connection/HypixelConnection;", "Lnet/hypixel/api/http/HypixelHttpClient;", "<init>", "()V", "apiKey", "", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "httpClient", "Lokhttp3/OkHttpClient;", "client", "Lio/ktor/client/HttpClient;", "hypixelApi", "Lnet/hypixel/api/HypixelAPI;", "getHypixelApi", "()Lnet/hypixel/api/HypixelAPI;", "makeRequest", "Ljava/util/concurrent/CompletableFuture;", "Lnet/hypixel/api/http/HypixelHttpResponse;", "url", "makeAuthenticatedRequest", "shutdown", "", "createRateLimitResponse", "Lnet/hypixel/api/http/RateLimit;", "response", "Lokhttp3/Response;", "getOnlineStatus", "Lnet/hypixel/api/reply/StatusReply$Session;", "uuid", "Ljava/util/UUID;", "hypixel-wrapper"})
public final class HypixelConnection
implements HypixelHttpClient {
    @NotNull
    public static final HypixelConnection INSTANCE = new HypixelConnection();
    @Nullable
    private static String apiKey = System.getenv("HYPIXEL_API_KEY");
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final OkHttpClient httpClient;
    @NotNull
    private static final HttpClient client;
    @NotNull
    private static final HypixelAPI hypixelApi;

    private HypixelConnection() {
    }

    @Nullable
    public final String getApiKey() {
        return apiKey;
    }

    public final void setApiKey(@Nullable String string) {
        apiKey = string;
    }

    @NotNull
    public final HypixelAPI getHypixelApi() {
        return hypixelApi;
    }

    @NotNull
    public CompletableFuture<HypixelHttpResponse> makeRequest(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CompletableFuture<HypixelHttpResponse> completableFuture = new CompletableFuture<HypixelHttpResponse>().completeAsync(() -> HypixelConnection.makeRequest$lambda$1(url));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completeAsync(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<HypixelHttpResponse> makeAuthenticatedRequest(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CompletableFuture<HypixelHttpResponse> completableFuture = new CompletableFuture<HypixelHttpResponse>().completeAsync(() -> HypixelConnection.makeAuthenticatedRequest$lambda$3(url));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completeAsync(...)");
        return completableFuture;
    }

    public void shutdown() {
    }

    private final RateLimit createRateLimitResponse(Response response) {
        if (response.code() != 200) {
            return null;
        }
        String string = Response.header$default((Response)response, (String)"RateLimit-Limit", null, (int)2, null);
        Integer limit = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        String string2 = Response.header$default((Response)response, (String)"RateLimit-Remaining", null, (int)2, null);
        Integer remaining = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
        String string3 = Response.header$default((Response)response, (String)"RateLimit-Reset", null, (int)2, null);
        Integer reset = string3 != null ? Integer.valueOf(Integer.parseInt(string3)) : null;
        Integer n = limit;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = remaining;
        Intrinsics.checkNotNull((Object)n3);
        int n4 = n3;
        Integer n5 = reset;
        Intrinsics.checkNotNull((Object)n5);
        return new RateLimit(n2, n4, n5.intValue());
    }

    @NotNull
    public final StatusReply.Session getOnlineStatus(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        StatusReply.Session session = ((StatusReply)hypixelApi.getStatus(uuid).join()).getSession();
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getSession(...)");
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HypixelHttpResponse makeRequest$lambda$1(String $url) {
        Request request = new Request.Builder().url($url).get().build();
        try {
            Closeable closeable = (Closeable)httpClient.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (response.body() != null) {
                    int n = response.code();
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    HypixelHttpResponse hypixelHttpResponse = new HypixelHttpResponse(n, responseBody.string(), null);
                    return hypixelHttpResponse;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ioException) {
            logger.error("Error when performing unauthenticated hypixel request");
        }
        throw new FailedToLoadException("Hypixel request wasn't successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HypixelHttpResponse makeAuthenticatedRequest$lambda$3(String $url) {
        Request.Builder builder = new Request.Builder();
        String string = apiKey;
        Intrinsics.checkNotNull((Object)string);
        Request request = builder.addHeader("API-Key", string).url($url).get().build();
        try {
            Closeable closeable = (Closeable)httpClient.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (response.body() != null) {
                    int n = response.code();
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    HypixelHttpResponse hypixelHttpResponse = new HypixelHttpResponse(n, responseBody.string(), INSTANCE.createRateLimitResponse(response));
                    return hypixelHttpResponse;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ioException) {
            logger.error("Error when performing authenticated hypixel request {}.", (Object)$url, (Object)ioException);
        }
        throw new FailedToLoadException("Hypixel request wasn't successful.");
    }

    static {
        Logger logger = LoggerFactory.getLogger(HypixelConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        HypixelConnection.logger = logger;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(true);
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder2 = builder.connectTimeout(duration);
        Duration duration2 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder3 = builder2.readTimeout(duration2);
        Duration duration3 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder4 = builder3.callTimeout(duration3);
        Duration duration4 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
        httpClient = builder4.writeTimeout(duration4).build();
        client = HttpClientJvmKt.HttpClient$default(null, (int)1, null);
        hypixelApi = new HypixelAPI((HypixelHttpClient)INSTANCE);
    }
}

