/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.connection;

import java.time.Duration;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.hypixel.client.ApiClient;
import net.dungeonhub.hypixel.client.FallbackApiClient;
import net.dungeonhub.hypixel.entities.SkyblockProfiles;
import net.dungeonhub.hypixel.entities.player.HypixelPlayer;
import net.dungeonhub.strategy.ApiClientStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\b\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lnet/dungeonhub/hypixel/connection/HypixelApiConnection;", "Lnet/dungeonhub/hypixel/client/ApiClient;", "strategy", "Lnet/dungeonhub/strategy/ApiClientStrategy;", "<init>", "(Lnet/dungeonhub/strategy/ApiClientStrategy;)V", "getStrategy", "()Lnet/dungeonhub/strategy/ApiClientStrategy;", "value", "client", "getClient", "()Lnet/dungeonhub/hypixel/client/ApiClient;", "getPlayerData", "Lnet/dungeonhub/hypixel/entities/player/HypixelPlayer;", "uuid", "Ljava/util/UUID;", "getSkyblockProfiles", "Lnet/dungeonhub/hypixel/entities/SkyblockProfiles;", "", "cacheExpiration", "getCacheExpiration", "()Ljava/lang/Integer;", "setCacheExpiration", "(Ljava/lang/Integer;)V", "withStrategy", "withCacheExpiration", "Ljava/time/Duration;", "hypixel-wrapper"})
public final class HypixelApiConnection
implements ApiClient {
    @NotNull
    private final ApiClientStrategy strategy;
    @NotNull
    private ApiClient client;

    public HypixelApiConnection(@NotNull ApiClientStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.strategy = strategy;
        this.client = this.strategy.getClient();
    }

    public /* synthetic */ HypixelApiConnection(ApiClientStrategy apiClientStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            apiClientStrategy = ApiClientStrategy.CacheWithRestFallback;
        }
        this(apiClientStrategy);
    }

    @NotNull
    public final ApiClientStrategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    public final ApiClient getClient() {
        return this.client;
    }

    @Override
    @Nullable
    public HypixelPlayer getPlayerData(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.strategy.getClient().getPlayerData(uuid);
    }

    @Override
    @Nullable
    public SkyblockProfiles getSkyblockProfiles(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.strategy.getClient().getSkyblockProfiles(uuid);
    }

    @Nullable
    public final Integer getCacheExpiration() {
        Integer n;
        if (this.client instanceof FallbackApiClient) {
            ApiClient apiClient = this.client;
            Intrinsics.checkNotNull((Object)apiClient, (String)"null cannot be cast to non-null type net.dungeonhub.hypixel.client.FallbackApiClient");
            n = ((FallbackApiClient)apiClient).getExpiresAfterMinutes();
        } else {
            n = null;
        }
        return n;
    }

    public final void setCacheExpiration(@Nullable Integer value) {
        if (this.client instanceof FallbackApiClient && value != null) {
            ApiClient apiClient = this.client;
            Intrinsics.checkNotNull((Object)apiClient, (String)"null cannot be cast to non-null type net.dungeonhub.hypixel.client.FallbackApiClient");
            this.client = ((FallbackApiClient)apiClient).withCacheExpiration(value);
        }
    }

    @NotNull
    public final HypixelApiConnection withStrategy(@NotNull ApiClientStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        return new HypixelApiConnection(strategy);
    }

    @NotNull
    public final HypixelApiConnection withCacheExpiration(int cacheExpiration) {
        HypixelApiConnection connection = new HypixelApiConnection(this.strategy);
        connection.setCacheExpiration(cacheExpiration);
        return connection;
    }

    @NotNull
    public final HypixelApiConnection withCacheExpiration(@NotNull Duration cacheExpiration) {
        Intrinsics.checkNotNullParameter((Object)cacheExpiration, (String)"cacheExpiration");
        return this.withCacheExpiration((int)cacheExpiration.toMinutes());
    }

    public HypixelApiConnection() {
        this(null, 1, null);
    }
}

