/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.client;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.cache.Cache;
import net.dungeonhub.hypixel.client.ApiClient;
import net.dungeonhub.hypixel.client.ApiClientWithCache;
import net.dungeonhub.hypixel.entities.SkyblockProfiles;
import net.dungeonhub.hypixel.entities.player.HypixelPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J9\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00132\b\u0010\u0014\u001a\u0004\u0018\u0001H\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lnet/dungeonhub/hypixel/client/StoringApiClient;", "Lnet/dungeonhub/hypixel/client/ApiClient;", "apiClient", "storage", "Lnet/dungeonhub/hypixel/client/ApiClientWithCache;", "<init>", "(Lnet/dungeonhub/hypixel/client/ApiClient;Lnet/dungeonhub/hypixel/client/ApiClientWithCache;)V", "getApiClient", "()Lnet/dungeonhub/hypixel/client/ApiClient;", "getStorage", "()Lnet/dungeonhub/hypixel/client/ApiClientWithCache;", "getPlayerData", "Lnet/dungeonhub/hypixel/entities/player/HypixelPlayer;", "uuid", "Ljava/util/UUID;", "getSkyblockProfiles", "Lnet/dungeonhub/hypixel/entities/SkyblockProfiles;", "storeAndReturn", "T", "K", "value", "cache", "Lnet/dungeonhub/cache/Cache;", "(Ljava/lang/Object;Lnet/dungeonhub/cache/Cache;)Ljava/lang/Object;", "hypixel-wrapper"})
public final class StoringApiClient
implements ApiClient {
    @NotNull
    private final ApiClient apiClient;
    @NotNull
    private final ApiClientWithCache storage;

    public StoringApiClient(@NotNull ApiClient apiClient, @NotNull ApiClientWithCache storage) {
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.apiClient = apiClient;
        this.storage = storage;
    }

    @NotNull
    public final ApiClient getApiClient() {
        return this.apiClient;
    }

    @NotNull
    public final ApiClientWithCache getStorage() {
        return this.storage;
    }

    @Override
    @Nullable
    public HypixelPlayer getPlayerData(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.storeAndReturn(this.apiClient.getPlayerData(uuid), this.storage.getPlayerDataCache());
    }

    @Override
    @Nullable
    public SkyblockProfiles getSkyblockProfiles(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.storeAndReturn(this.apiClient.getSkyblockProfiles(uuid), this.storage.getSkyblockProfilesCache());
    }

    private final <T, K> T storeAndReturn(T value, Cache<T, K> cache) {
        if (value == null) {
            return null;
        }
        cache.store(value);
        return value;
    }
}

