/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.dungeonhub.hypixel.client.ApiClient;
import net.dungeonhub.hypixel.connection.HypixelConnection;
import net.dungeonhub.hypixel.entities.SkyblockProfileKt;
import net.dungeonhub.hypixel.entities.SkyblockProfiles;
import net.dungeonhub.hypixel.entities.player.HypixelPlayer;
import net.dungeonhub.hypixel.entities.player.HypixelPlayerKt;
import net.hypixel.api.reply.PlayerReply;
import net.hypixel.api.reply.skyblock.SkyBlockProfilesReply;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/hypixel/client/RestApiClient;", "Lnet/dungeonhub/hypixel/client/ApiClient;", "<init>", "()V", "getPlayerData", "Lnet/dungeonhub/hypixel/entities/player/HypixelPlayer;", "uuid", "Ljava/util/UUID;", "getSkyblockProfiles", "Lnet/dungeonhub/hypixel/entities/SkyblockProfiles;", "fetchSkyblockProfiles", "Lcom/google/gson/JsonArray;", "hypixel-wrapper"})
@SourceDebugExtension(value={"SMAP\nRestApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestApiClient.kt\nnet/dungeonhub/hypixel/client/RestApiClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1557#2:36\n1628#2,3:37\n*S KotlinDebug\n*F\n+ 1 RestApiClient.kt\nnet/dungeonhub/hypixel/client/RestApiClient\n*L\n26#1:36\n26#1:37,3\n*E\n"})
public final class RestApiClient
implements ApiClient {
    @NotNull
    public static final RestApiClient INSTANCE = new RestApiClient();

    private RestApiClient() {
    }

    @Override
    @Nullable
    public HypixelPlayer getPlayerData(@NotNull UUID uuid) {
        PlayerReply.Player player;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        PlayerReply.Player player2 = player = ((PlayerReply)HypixelConnection.INSTANCE.getHypixelApi().getPlayerByUuid(uuid).join()).getPlayer();
        if ((player2 != null ? player2.getUuid() : null) == null) {
            return null;
        }
        JsonObject jsonObject = player.getRaw();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getRaw(...)");
        return HypixelPlayerKt.toHypixelPlayer(jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SkyblockProfiles getSkyblockProfiles(@NotNull UUID uuid) {
        List list;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        UUID uUID = uuid;
        Object object = this.fetchSkyblockProfiles(uuid);
        if (object != null && (object = object.asList()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)object;
            UUID uUID2 = uUID;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(SkyblockProfileKt.toSkyblockProfile((JsonElement)it));
            }
            list = (List)destination$iv$iv;
            uUID = uUID2;
        } else {
            list = CollectionsKt.emptyList();
        }
        List list2 = list;
        UUID uUID3 = uUID;
        return new SkyblockProfiles(uUID3, list2);
    }

    @Nullable
    public final JsonArray fetchSkyblockProfiles(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return ((SkyBlockProfilesReply)HypixelConnection.INSTANCE.getHypixelApi().getSkyBlockProfiles(uuid).join()).getProfiles();
    }
}

