/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.client;

import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.cache.disk.DiskHistoryCache;
import net.dungeonhub.cache.memory.CacheElement;
import net.dungeonhub.hypixel.client.ApiClientWithCache;
import net.dungeonhub.hypixel.entities.SkyblockProfiles;
import net.dungeonhub.hypixel.entities.player.HypixelPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u000e"}, d2={"Lnet/dungeonhub/hypixel/client/DiskCacheApiClient;", "Lnet/dungeonhub/hypixel/client/ApiClientWithCache;", "<init>", "()V", "playerDataCache", "Lnet/dungeonhub/cache/disk/DiskHistoryCache;", "Lnet/dungeonhub/hypixel/entities/player/HypixelPlayer;", "getPlayerDataCache", "()Lnet/dungeonhub/cache/disk/DiskHistoryCache;", "skyblockProfilesCache", "Lnet/dungeonhub/hypixel/entities/SkyblockProfiles;", "getSkyblockProfilesCache", "clearCache", "", "hypixel-wrapper"})
public final class DiskCacheApiClient
implements ApiClientWithCache {
    @NotNull
    public static final DiskCacheApiClient INSTANCE = new DiskCacheApiClient();
    @NotNull
    private static final DiskHistoryCache<HypixelPlayer> playerDataCache = new DiskHistoryCache("player-data", (TypeToken)new TypeToken<CacheElement<HypixelPlayer>>(){}, DiskCacheApiClient::playerDataCache$lambda$0);
    @NotNull
    private static final DiskHistoryCache<SkyblockProfiles> skyblockProfilesCache = new DiskHistoryCache("skyblock-profiles", (TypeToken)new TypeToken<CacheElement<SkyblockProfiles>>(){}, DiskCacheApiClient::skyblockProfilesCache$lambda$1);

    private DiskCacheApiClient() {
    }

    @NotNull
    public DiskHistoryCache<HypixelPlayer> getPlayerDataCache() {
        return playerDataCache;
    }

    @NotNull
    public DiskHistoryCache<SkyblockProfiles> getSkyblockProfilesCache() {
        return skyblockProfilesCache;
    }

    public final void clearCache() {
        Path cacheDirectory = Path.of(DiskHistoryCache.Companion.getCacheDirectory(), new String[0]);
        Intrinsics.checkNotNull((Object)cacheDirectory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(cacheDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            DiskHistoryCache.Companion.deleteDirectoryWithContents(cacheDirectory);
        }
    }

    private static final UUID playerDataCache$lambda$0(HypixelPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUuid();
    }

    private static final UUID skyblockProfilesCache$lambda$1(SkyblockProfiles it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getOwner();
    }
}

