/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.hypixel.client;

import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.cache.Cache;
import net.dungeonhub.cache.memory.CacheElement;
import net.dungeonhub.hypixel.client.ApiClient;
import net.dungeonhub.hypixel.entities.SkyblockProfiles;
import net.dungeonhub.hypixel.entities.player.HypixelPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J8\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lnet/dungeonhub/hypixel/client/ApiClientWithCache;", "Lnet/dungeonhub/hypixel/client/ApiClient;", "playerDataCache", "Lnet/dungeonhub/cache/Cache;", "Lnet/dungeonhub/hypixel/entities/player/HypixelPlayer;", "Ljava/util/UUID;", "getPlayerDataCache", "()Lnet/dungeonhub/cache/Cache;", "skyblockProfilesCache", "Lnet/dungeonhub/hypixel/entities/SkyblockProfiles;", "getSkyblockProfilesCache", "isExpired", "", "T", "", "cache", "uuid", "expiresAfterMinutes", "", "getPlayerData", "getSkyblockProfiles", "hypixel-wrapper"})
public interface ApiClientWithCache
extends ApiClient {
    @NotNull
    public Cache<HypixelPlayer, UUID> getPlayerDataCache();

    @NotNull
    public Cache<SkyblockProfiles, UUID> getSkyblockProfilesCache();

    default public <T> boolean isExpired(@NotNull Cache<T, UUID> cache, @NotNull UUID uuid, int expiresAfterMinutes) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CacheElement<T> cacheElement = cache.retrieveElement(uuid);
        return cacheElement != null && (cacheElement = cacheElement.getTimeAdded()) != null && (cacheElement = ((Instant)((Object)cacheElement)).plusSeconds((long)expiresAfterMinutes * 60L)) != null ? ((Instant)((Object)cacheElement)).isBefore(Instant.now()) : true;
    }

    public static /* synthetic */ boolean isExpired$default(ApiClientWithCache apiClientWithCache, Cache cache, UUID uUID, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isExpired");
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        return apiClientWithCache.isExpired(cache, uUID, n);
    }

    @Override
    @Nullable
    default public HypixelPlayer getPlayerData(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.getPlayerDataCache().retrieve(uuid);
    }

    @Override
    @Nullable
    default public SkyblockProfiles getSkyblockProfiles(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.getSkyblockProfilesCache().retrieve(uuid);
    }
}

