/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.cache.memory;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.cache.Cache;
import net.dungeonhub.cache.memory.CacheElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u0012H\u0016J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR6\u0010\n\u001a*\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bj\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/dungeonhub/cache/memory/HashMapCache;", "T", "K", "Lnet/dungeonhub/cache/Cache;", "keyFunction", "Lkotlin/Function1;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getKeyFunction", "()Lkotlin/jvm/functions/Function1;", "cache", "Ljava/util/HashMap;", "Lnet/dungeonhub/cache/memory/CacheElement;", "Lkotlin/collections/HashMap;", "retrieveElement", "key", "(Ljava/lang/Object;)Lnet/dungeonhub/cache/memory/CacheElement;", "retrieveAllElements", "", "store", "", "value", "(Ljava/lang/Object;)V", "invalidateEntry", "hypixel-wrapper"})
public final class HashMapCache<T, K>
implements Cache<T, K> {
    @NotNull
    private final Function1<T, K> keyFunction;
    @NotNull
    private final HashMap<K, CacheElement<T>> cache;

    public HashMapCache(@NotNull Function1<? super T, ? extends K> keyFunction) {
        Intrinsics.checkNotNullParameter(keyFunction, (String)"keyFunction");
        this.keyFunction = keyFunction;
        this.cache = new HashMap();
    }

    @NotNull
    public final Function1<T, K> getKeyFunction() {
        return this.keyFunction;
    }

    @Override
    @Nullable
    public CacheElement<T> retrieveElement(K key) {
        return this.cache.get(key);
    }

    @Override
    @NotNull
    public List<CacheElement<T>> retrieveAllElements() {
        Collection<CacheElement<T>> collection = this.cache.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    public void store(T value) {
        Map map = this.cache;
        Object object = this.keyFunction.invoke(value);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        CacheElement<T> cacheElement = new CacheElement<T>(instant, value);
        map.put(object, cacheElement);
    }

    @Override
    public void invalidateEntry(K key) {
        this.cache.remove(key);
    }
}

