/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.cache.disk;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.cache.Cache;
import net.dungeonhub.cache.memory.CacheElement;
import net.dungeonhub.provider.GsonProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 %*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002:\u0001%B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0015\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020 J\u000e\u0010$\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lnet/dungeonhub/cache/disk/DiskHistoryCache;", "T", "Lnet/dungeonhub/cache/Cache;", "Ljava/util/UUID;", "name", "", "type", "Lcom/google/gson/reflect/TypeToken;", "Lnet/dungeonhub/cache/memory/CacheElement;", "keyFunction", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;Lcom/google/gson/reflect/TypeToken;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "getType", "()Lcom/google/gson/reflect/TypeToken;", "getKeyFunction", "()Lkotlin/jvm/functions/Function1;", "getDirectory", "Ljava/nio/file/Path;", "uuid", "getDataFile", "getHistoryDirectory", "getHistoryFile", "instant", "Ljava/time/Instant;", "retrieveElement", "key", "retrieveAllElements", "", "invalidateEntry", "", "store", "value", "(Ljava/lang/Object;)V", "clearHistoryDirectory", "Companion", "hypixel-wrapper"})
public final class DiskHistoryCache<T>
implements Cache<T, UUID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final TypeToken<CacheElement<T>> type;
    @NotNull
    private final Function1<T, UUID> keyFunction;
    @NotNull
    private static String cacheDirectory = System.getProperty("user.home") + File.separator + "dungeon-hub" + File.separator + "hypixel-wrapper-cache";

    public DiskHistoryCache(@NotNull String name, @NotNull TypeToken<CacheElement<T>> type, @NotNull Function1<? super T, UUID> keyFunction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(keyFunction, (String)"keyFunction");
        this.name = name;
        this.type = type;
        this.keyFunction = keyFunction;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final TypeToken<CacheElement<T>> getType() {
        return this.type;
    }

    @NotNull
    public final Function1<T, UUID> getKeyFunction() {
        return this.keyFunction;
    }

    @NotNull
    public final Path getDirectory(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String[] stringArray = new String[]{this.name, uuid.toString()};
        Path directory = Path.of(cacheDirectory, stringArray);
        Intrinsics.checkNotNull((Object)directory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(directory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        return directory;
    }

    @NotNull
    public final Path getDataFile(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Path dataFile = this.getDirectory(uuid).resolve("data.json");
        Intrinsics.checkNotNull((Object)dataFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(dataFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createFile(dataFile, new FileAttribute[0]);
        }
        return dataFile;
    }

    @NotNull
    public final Path getHistoryDirectory() {
        String[] stringArray = new String[]{"history", this.name};
        Path historyDirectory = Path.of(cacheDirectory, stringArray);
        Intrinsics.checkNotNull((Object)historyDirectory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(historyDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(historyDirectory, new FileAttribute[0]);
        }
        return historyDirectory;
    }

    @NotNull
    public final Path getHistoryDirectory(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Path historyDirectory = this.getHistoryDirectory().resolve(uuid.toString());
        Intrinsics.checkNotNull((Object)historyDirectory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(historyDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectory(historyDirectory, new FileAttribute[0]);
        }
        return historyDirectory;
    }

    @NotNull
    public final Path getHistoryFile(@NotNull UUID uuid, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        Path path = this.getHistoryDirectory(uuid).resolve(instant.toEpochMilli() + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    @Nullable
    public CacheElement<T> retrieveElement(@NotNull UUID key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Path dataFile = this.getDataFile(key);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(dataFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            String json = Files.readString(dataFile);
            return (CacheElement)GsonProvider.INSTANCE.getGson().fromJson(json, this.type.getType());
        }
        return null;
    }

    @Override
    @NotNull
    public List<CacheElement<T>> retrieveAllElements() {
        Object object = new String[]{this.name};
        Path cacheDirectory = Path.of(DiskHistoryCache.cacheDirectory, object);
        Intrinsics.checkNotNull((Object)cacheDirectory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(cacheDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        object = Files.list(cacheDirectory).map(arg_0 -> DiskHistoryCache.retrieveAllElements$lambda$1(arg_0 -> DiskHistoryCache.retrieveAllElements$lambda$0(this, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toList(...)");
        return CollectionsKt.filterNotNull((Iterable)((Iterable)object));
    }

    @Override
    public void invalidateEntry(@NotNull UUID key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CacheElement<T> cacheElement = this.retrieveElement(key);
        Path dataFile = this.getDataFile(key);
        if (cacheElement != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(dataFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.move(dataFile, this.getHistoryFile(key, cacheElement.getTimeAdded()), new CopyOption[0]);
            }
        }
    }

    @Override
    public void store(T value) {
        UUID uuid = (UUID)this.keyFunction.invoke(value);
        this.invalidateEntry(uuid);
        Path path = this.getDataFile(uuid);
        Gson gson = GsonProvider.INSTANCE.getGson();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Files.writeString(path, (CharSequence)gson.toJson(new CacheElement<T>(instant, value)), new OpenOption[0]);
    }

    public final void clearHistoryDirectory() {
        Companion.deleteDirectoryWithContents(this.getHistoryDirectory());
    }

    public final void clearHistoryDirectory(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Companion.deleteDirectoryWithContents(this.getHistoryDirectory(uuid));
    }

    private static final CacheElement retrieveAllElements$lambda$0(DiskHistoryCache this$0, Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            UUID uUID;
            try {
                uUID = UUID.fromString(PathsKt.getName((Path)it));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            UUID uuid = uUID;
            Intrinsics.checkNotNull((Object)uuid);
            return this$0.retrieveElement(uuid);
        }
        return null;
    }

    private static final CacheElement retrieveAllElements$lambda$1(Function1 $tmp0, Object p0) {
        return (CacheElement)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lnet/dungeonhub/cache/disk/DiskHistoryCache$Companion;", "", "<init>", "()V", "cacheDirectory", "", "getCacheDirectory", "()Ljava/lang/String;", "setCacheDirectory", "(Ljava/lang/String;)V", "deleteDirectoryWithContents", "", "rootPath", "Ljava/nio/file/Path;", "hypixel-wrapper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCacheDirectory() {
            return cacheDirectory;
        }

        public final void setCacheDirectory(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            cacheDirectory = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void deleteDirectoryWithContents(@NotNull Path rootPath) {
            Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(rootPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return;
            }
            AutoCloseable autoCloseable = Files.walk(rootPath, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream walk = (Stream)autoCloseable;
                boolean bl = false;
                walk.sorted(Comparator.reverseOrder()).forEach(arg_0 -> Companion.deleteDirectoryWithContents$lambda$2$lambda$1(Companion::deleteDirectoryWithContents$lambda$2$lambda$0, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private static final Unit deleteDirectoryWithContents$lambda$2$lambda$0(Path obj) {
            Files.delete(obj);
            return Unit.INSTANCE;
        }

        private static final void deleteDirectoryWithContents$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

