/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.protocol.akka;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import net.dubboclub.akka.remoting.actor.BasicActor;

public class AkkaInvoker<T>
implements Invoker<T> {
    private BasicActor actor;
    private URL url;
    private Class<T> type;
    private volatile boolean isAvailable = false;

    public AkkaInvoker(BasicActor actor, URL url, Class<T> type) {
        this.actor = actor;
        this.url = url;
        this.type = type;
        this.isAvailable = true;
    }

    public Class<T> getInterface() {
        return this.type;
    }

    public Result invoke(Invocation invocation) throws RpcException {
        if (this.isAvailable) {
            ResponseFuture future = this.actor.tell((Object)invocation);
            try {
                return (Result)future.get();
            }
            catch (RemotingException e) {
                throw new RpcException("Akka invoker for type " + this.type + " is not available", (Throwable)e);
            }
        }
        throw new RpcException("Akka invoker for type " + this.type + " is not available");
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void destroy() {
        this.isAvailable = false;
        this.actor.destroy();
    }
}

