/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.protocol.akka;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.remoting.exchange.ExchangeServer;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.protocol.AbstractProtocol;
import java.util.concurrent.ConcurrentHashMap;
import net.dubboclub.akka.remoting.ActorExchanger;
import net.dubboclub.protocol.akka.AkkaExporter;
import net.dubboclub.protocol.akka.AkkaInvoker;

public class AkkaProtocol
extends AbstractProtocol {
    private static final String AKKA_TRANSPORTER_NAME = "akka";
    private static final int DEFAULT_PORT = 2552;
    private static volatile ActorExchanger exchanger = null;
    private static ConcurrentHashMap<String, ExchangeServer> serverMap = new ConcurrentHashMap();

    public int getDefaultPort() {
        return 2552;
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        URL url = invoker.getUrl();
        return new AkkaExporter<T>(invoker, this.getExchanger().bind(invoker));
    }

    private ActorExchanger getExchanger() {
        if (!ExtensionLoader.getExtensionLoader(ActorExchanger.class).hasExtension(AKKA_TRANSPORTER_NAME)) {
            throw new RpcException("Not found akka ActorExchanger extension in ExtensionLoader");
        }
        if (exchanger == null) {
            exchanger = (ActorExchanger)ExtensionLoader.getExtensionLoader(ActorExchanger.class).getExtension(AKKA_TRANSPORTER_NAME);
        }
        return exchanger;
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        return new AkkaInvoker<T>(this.getExchanger().connect(type, url), url, type);
    }
}

