/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.util;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyFutures {
    public static <V> CompletableFuture<V> toCompletable(final Future<V> future) {
        return new CompletableFuture<V>(){
            {
                future.addListener(f -> {
                    try {
                        this.complete(future.getNow());
                    }
                    catch (Throwable ex) {
                        this.completeExceptionally(ex);
                    }
                });
            }

            @Override
            public boolean cancel(boolean interrupt) {
                try {
                    boolean bl = future.cancel(interrupt);
                    return bl;
                }
                finally {
                    super.cancel(interrupt);
                }
            }
        };
    }

    public static <V> void copy(Future<V> future, CompletableFuture<V> target) {
        future.addListener(f -> {
            try {
                Object result = f.get();
                target.complete(result);
            }
            catch (ExecutionException ex) {
                target.completeExceptionally(ex.getCause());
            }
            catch (Throwable ex) {
                target.completeExceptionally(ex);
            }
        });
    }

    public static <V> CompletableFuture<V> join(final Future<V> one, final Future<V> two) {
        return new CompletableFuture<V>(){
            {
                AtomicInteger count = new AtomicInteger(2);
                GenericFutureListener listener = f -> {
                    try {
                        Object v = f.getNow();
                        if (count.decrementAndGet() == 0) {
                            this.complete(v);
                        }
                    }
                    catch (Throwable ex) {
                        this.completeExceptionally(ex);
                    }
                };
                one.addListener(listener);
                two.addListener(listener);
            }

            @Override
            public boolean cancel(boolean interrupt) {
                try {
                    boolean bl = one.cancel(interrupt) | two.cancel(interrupt);
                    return bl;
                }
                finally {
                    super.cancel(interrupt);
                }
            }
        };
    }
}

