/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.DuplexChannelConfig;
import java.util.concurrent.CompletableFuture;
import net.dryuf.base.concurrent.future.FutureUtil;
import net.dryuf.netty.core.NettyEngine;
import net.dryuf.netty.util.NettyFutures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForwarderHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LogManager.getLogger(ForwarderHandler.class);
    private final NettyEngine nettyEngine;
    private final DuplexChannel source;
    private final DuplexChannel destination;
    private final CompletableFuture<Void> finishPromise;
    private ChannelConfig config;
    private boolean isShutdown;

    public ForwarderHandler(NettyEngine nettyEngine, DuplexChannel source, DuplexChannel destination, CompletableFuture<Void> finishPromise) {
        this.nettyEngine = nettyEngine;
        this.source = source;
        this.destination = destination;
        this.finishPromise = finishPromise;
        this.config = source.config();
        this.config.setAutoRead(false);
        this.config.setAutoClose(false);
        if (this.config instanceof DuplexChannelConfig) {
            ((DuplexChannelConfig)this.config).setAllowHalfClosure(true);
        }
        source.closeFuture().addListener(f -> NettyFutures.copy(source.closeFuture(), finishPromise));
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf input = (ByteBuf)msg;
        this.destination.write((Object)input);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ChannelFuture future = this.destination.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
        future.addListener(f -> ctx.read());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ChannelInputShutdownEvent) {
            this.isShutdown = true;
            FutureUtil.copy(this.nettyEngine.shutdownOutput(this.destination), this.finishPromise);
        } else {
            ctx.read();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable ex) throws Exception {
        this.finishPromise.completeExceptionally(ex);
        ctx.close();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }
}

