/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.forward;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.dryuf.base.concurrent.future.FutureUtil;
import net.dryuf.netty.address.AddressSpec;
import net.dryuf.netty.core.NettyEngine;
import net.dryuf.netty.core.NettyServer;
import net.dryuf.netty.core.Server;
import net.dryuf.netty.forward.PortForwarderFactory;
import net.dryuf.netty.pipeline.FullFlowControlHandler;
import net.dryuf.netty.util.NettyFutures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class NettyPortForwarderFactory
implements PortForwarderFactory {
    private static final Logger log = LogManager.getLogger(NettyPortForwarderFactory.class);
    private final NettyEngine nettyEngine;

    @Override
    public List<CompletableFuture<Server>> runForwards(List<PortForwarderFactory.ForwardConfig> forwards) {
        List<CompletableFuture<Server>> futures = forwards.stream().map(this::runForward).collect(Collectors.toList());
        return futures;
    }

    @Override
    public CompletableFuture<Server> runForward(PortForwarderFactory.ForwardConfig forward) {
        try {
            Preconditions.checkArgument((forward.getBind() != null ? 1 : 0) != 0, (Object)"bind must be specified");
            switch (Optional.ofNullable(forward.getBind().getProto()).orElse("")) {
                case "tcp4": 
                case "tcp6": {
                    break;
                }
                case "unix": 
                case "domain": {
                    Preconditions.checkArgument((forward.getBind().getPath() != null ? 1 : 0) != 0, (Object)"path not specified");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown bind.proto: " + forward.getBind().getProto());
                }
            }
            Preconditions.checkArgument((forward.getConnect() != null ? 1 : 0) != 0, (Object)"connect must be specified");
            switch (Optional.ofNullable(forward.getConnect().getProto()).orElse("")) {
                case "tcp4": 
                case "tcp6": {
                    Preconditions.checkArgument((forward.getConnect().getPort() != 0 ? 1 : 0) != 0, (Object)"port not specified");
                    Preconditions.checkArgument((forward.getConnect().getHost() != null ? 1 : 0) != 0, (Object)"host not specified");
                    break;
                }
                case "unix": 
                case "domain": {
                    Preconditions.checkArgument((forward.getConnect().getPath() != null ? 1 : 0) != 0, (Object)"path not specified");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown connect.proto: " + forward.getConnect().getProto());
                }
            }
        }
        catch (Throwable ex) {
            return FutureUtil.exception((Throwable)ex);
        }
        return this.runForwarder(forward);
    }

    private CompletableFuture<Server> runForwarder(final PortForwarderFactory.ForwardConfig config) {
        return new CompletableFuture<Server>(){
            private CompletableFuture<ServerChannel> initFuture;
            private ServerChannel listener;
            {
                try {
                    this.createListener(config.getBind());
                }
                catch (Throwable ex) {
                    this.fail(ex);
                }
            }

            @Override
            public synchronized boolean cancel(boolean interrupt) {
                if (this.listener != null) {
                    this.listener.close();
                }
                this.initFuture.cancel(interrupt);
                return super.cancel(interrupt);
            }

            public synchronized boolean setListener(ServerChannel listener) {
                if (this.isDone()) {
                    return false;
                }
                this.listener = listener;
                return true;
            }

            private void fail(Throwable ex) {
                if (this.listener != null) {
                    this.listener.close();
                }
                this.completeExceptionally(ex);
            }

            private void connectForward(DuplexChannel client, AddressSpec connect) {
                NettyPortForwarderFactory.this.nettyEngine.connect(connect, (ChannelHandler)new ChannelInitializer<DuplexChannel>(){

                    public void initChannel(DuplexChannel server) throws Exception {
                        server.config().setAutoRead(false);
                        server.pipeline().addLast(new ChannelHandler[]{new FullFlowControlHandler()});
                    }
                }).whenComplete((server, ex) -> {
                    if (ex == null) {
                        NettyPortForwarderFactory.this.nettyEngine.forwardDuplex(client, (DuplexChannel)server).whenComplete((v, ex2) -> NettyFutures.join(client.close(), server.close()));
                    } else {
                        log.error("Failed to connect to: {}", (Object)connect, ex);
                        client.close();
                    }
                });
            }

            private void createListener(AddressSpec address) throws InterruptedException {
                this.initFuture = NettyPortForwarderFactory.this.nettyEngine.listen(address, new ChannelInitializer<DuplexChannel>(){

                    public void initChannel(DuplexChannel client) throws Exception {
                        client.config().setAutoRead(false);
                        client.pipeline().addFirst(new ChannelHandler[]{new FullFlowControlHandler()});
                        this.connectForward(client, config.getConnect());
                    }
                });
                this.initFuture.whenComplete((channel, ex) -> {
                    if (ex != null) {
                        this.fail((Throwable)ex);
                    } else if (!this.setListener((ServerChannel)channel)) {
                        channel.close();
                    } else {
                        CompletableFuture<Void> close = new CompletableFuture<Void>(){

                            @Override
                            public synchronized boolean cancel(boolean interrupt) {
                                channel.close();
                                return super.cancel(interrupt);
                            }
                        };
                        this.complete(new NettyServer((Channel)channel));
                    }
                });
            }
        };
    }

    private SocketAddress createAddress(AddressSpec addressSpec) {
        switch (addressSpec.getProto()) {
            case "tcp4": 
            case "tcp6": {
                return InetSocketAddress.createUnresolved(addressSpec.getHost(), addressSpec.getPort());
            }
            case "domain": 
            case "unix": {
                return new DomainSocketAddress(addressSpec.getPath());
            }
        }
        throw new IllegalStateException("Improperly validated config, expected tcp4 or tcp6 or domain or unix for proto: " + String.valueOf(addressSpec));
    }

    @Override
    public void close() {
    }

    @Inject
    public NettyPortForwarderFactory(NettyEngine nettyEngine) {
        this.nettyEngine = nettyEngine;
    }
}

