/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.address;

import io.netty.channel.unix.DomainSocketAddress;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class AddressSpec {
    public static final String PROTO_TCP = "tcp";
    public static final String PROTO_TCP4 = "tcp4";
    public static final String PROTO_TCP6 = "tcp6";
    public static final String PROTO_UDP = "udp";
    public static final String PROTO_UDP4 = "udp4";
    public static final String PROTO_UDP6 = "udp6";
    public static final String PROTO_UNIX = "unix";
    public static final String PROTO_DOMAIN = "domain";
    public static final String ANY_HOST = "*";
    private final String proto;
    private final String path;
    private final String host;
    private final int port;

    public static AddressSpec fromSocketAddress(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return AddressSpec.builder().proto(PROTO_DOMAIN).path(((DomainSocketAddress)address).path()).build();
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress a = (InetSocketAddress)address;
            return AddressSpec.builder().proto(a.getAddress() instanceof Inet6Address ? PROTO_TCP6 : PROTO_TCP4).host(a.getHostString()).port(a.getPort()).build();
        }
        throw new UnsupportedOperationException("Unsupported SocketAddress: " + address.getClass().getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.proto);
        sb.append("://");
        if (this.proto.equals(PROTO_UNIX) || this.proto.equals(PROTO_DOMAIN)) {
            sb.append(this.path);
        } else {
            sb.append(this.host).append(":").append(this.port);
        }
        return sb.toString();
    }

    AddressSpec(String proto, String path, String host, int port) {
        this.proto = proto;
        this.path = path;
        this.host = host;
        this.port = port;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProto() {
        return this.proto;
    }

    public String getPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressSpec)) {
            return false;
        }
        AddressSpec other = (AddressSpec)o;
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$proto = this.getProto();
        String other$proto = other.getProto();
        if (this$proto == null ? other$proto != null : !this$proto.equals(other$proto)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $proto = this.getProto();
        result = result * 59 + ($proto == null ? 43 : $proto.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public static class Builder {
        private String proto;
        private String path;
        private String host;
        private int port;

        Builder() {
        }

        public Builder proto(String proto) {
            this.proto = proto;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public AddressSpec build() {
            return new AddressSpec(this.proto, this.path, this.host, this.port);
        }

        public String toString() {
            return "AddressSpec.Builder(proto=" + this.proto + ", path=" + this.path + ", host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

