/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.serialization.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import net.dreceiptx.receipt.common.DespatchInformation;
import net.dreceiptx.receipt.common.LocationInformation;
import net.dreceiptx.receipt.common.Measurement.TradeItemMeasurements;
import net.dreceiptx.receipt.ecom.AVP;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.LineItemFactory;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TradeItemIdentification;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.tax.Tax;
import net.dreceiptx.receipt.validation.ReceiptDeserializationException;

public class LineItemDeserializer
implements JsonDeserializer<LineItem> {
    private transient TransactionalTradeItemType _transactionalTradeItemType = null;
    private TradeItemDescriptionInformation _tradeItemDescriptionInformation = null;
    private transient String _transactionalTradeItemCode = null;
    private TradeItemIdentification _tradeItemIdentification = new TradeItemIdentification();
    private LineItemFactory _lineItemFactory = new LineItemFactory();

    public LineItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        JsonObject lineItemObject = (JsonObject)json;
        LineItem lineItem = null;
        try {
            Integer quantity = lineItemObject.get("invoicedQuantity").getAsInt();
            Double price = lineItemObject.get("itemPriceExclusiveAllowancesCharges").getAsDouble();
            JsonObject transactionalTradeItemObject = lineItemObject.get("transactionalTradeItem").getAsJsonObject();
            if (transactionalTradeItemObject.has("additionalTradeItemIdentification")) {
                JsonArray additionalTradeItemIdentifications = transactionalTradeItemObject.get("additionalTradeItemIdentification").getAsJsonArray();
                for (int i = 0; i < additionalTradeItemIdentifications.size(); ++i) {
                    JsonObject additionalTradeItemIdentificationObject = additionalTradeItemIdentifications.get(i).getAsJsonObject();
                    this._tradeItemIdentification.add(additionalTradeItemIdentificationObject.get("additionalTradeItemIdentificationType").getAsString(), additionalTradeItemIdentificationObject.get("additionalTradeItemIdentificationValue").getAsString());
                }
            }
            String DRX_LINEITEM_TYPE = this._tradeItemIdentification.get("DRX_LINEITEM_TYPE", "STANDARD");
            if (!transactionalTradeItemObject.has("tradeItemDescriptionInformation")) {
                throw new ReceiptDeserializationException("TradeItemDescriptionInformation is required, unsupported Digital Receipt format");
            }
            TradeItemDescriptionInformation tradeItemDescriptionInformation = (TradeItemDescriptionInformation)new Gson().fromJson((JsonElement)transactionalTradeItemObject.get("tradeItemDescriptionInformation").getAsJsonObject(), TradeItemDescriptionInformation.class);
            lineItem = this._lineItemFactory.createLineItem(DRX_LINEITEM_TYPE, tradeItemDescriptionInformation, quantity, price);
            if (transactionalTradeItemObject.has("gtin")) {
                String gtin = transactionalTradeItemObject.get("gtin").getAsString();
                lineItem.setTransactionalTradeItemType(TransactionalTradeItemType.GTIN, gtin);
            }
            lineItem.setTradeItemIdentification(this._tradeItemIdentification);
            lineItem.setLineItemId(lineItemObject.get("lineItemNumber").getAsInt());
            if (transactionalTradeItemObject.has("tradeItemMeasurements")) {
                lineItem.setTradeItemMeasurements((TradeItemMeasurements)ctx.deserialize(transactionalTradeItemObject.get("tradeItemMeasurements"), TradeItemMeasurements.class));
            }
            if (lineItemObject.get("creditLineIndicator").getAsBoolean()) {
                lineItem.setReturnOrExchange();
            }
            if (transactionalTradeItemObject.has("transactionalItemData")) {
                JsonObject transactionalItemData = transactionalTradeItemObject.get("transactionalItemData").getAsJsonObject();
                if (transactionalItemData.has("batchNumber")) {
                    lineItem.setBatchNumber(transactionalItemData.get("batchNumber").getAsString());
                }
                if (transactionalItemData.has("serialNumber")) {
                    lineItem.setSerialNumber(transactionalItemData.get("serialNumber").getAsString());
                }
            }
            if (lineItemObject.has("invoiceLineTaxInformation")) {
                JsonArray invoiceLineTaxInformation = lineItemObject.getAsJsonArray("invoiceLineTaxInformation");
                for (int i = 0; i < invoiceLineTaxInformation.size(); ++i) {
                    lineItem.addTax((Tax)ctx.deserialize(invoiceLineTaxInformation.get(i), Tax.class));
                }
            }
            if (lineItemObject.has("note")) {
                lineItem.setNote(lineItemObject.get("note").getAsString());
            }
            if (lineItemObject.has("billingCostCentre")) {
                JsonObject billingCostCentre = lineItemObject.get("billingCostCentre").getAsJsonObject();
                lineItem.setBillingCostCentre(billingCostCentre.get("entityIdentification").getAsString());
            }
            if (lineItemObject.has("shipFrom")) {
                lineItem.setOriginInformation((LocationInformation)ctx.deserialize(lineItemObject.get("shipFrom"), LocationInformation.class));
            }
            if (lineItemObject.has("shipTo")) {
                lineItem.setDestinationInformation((LocationInformation)ctx.deserialize(lineItemObject.get("shipTo"), LocationInformation.class));
            }
            if (lineItemObject.has("despatchInformation")) {
                lineItem.setDespatchInformation((DespatchInformation)ctx.deserialize(lineItemObject.get("despatchInformation"), DespatchInformation.class));
            }
            if (lineItemObject.has("avpList")) {
                JsonArray avpList = lineItemObject.get("avpList").getAsJsonArray();
                for (int i = 0; i < avpList.size(); ++i) {
                    lineItem.addEcomAVP((AVP)ctx.deserialize((JsonElement)avpList.get(i).getAsJsonObject(), AVP.class));
                }
            }
        }
        catch (Exception e) {
            String error = e.toString();
            String string = e.getMessage();
        }
        return lineItem;
    }
}

