/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.travel;

import java.util.Date;
import net.dreceiptx.receipt.ecom.AVPType;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.lineitem.travel.FlightDestinationType;
import net.dreceiptx.receipt.lineitem.travel.FlightType;

public class Flight
extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL0002";

    public Flight(FlightType flightType, String airline, String shortItinerary, String longItinerary, int quantity, double price) {
        super(airline, shortItinerary, longItinerary, quantity, price);
        this.setTradeItemGroupIdentificationCode(flightType.code());
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public Flight(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public String getAirline() {
        return this.getBrandName();
    }

    public String getItinerary() {
        return this.getName();
    }

    public String getItineraryDescription() {
        return this.getDescription();
    }

    public FlightType getFlightType() {
        return (FlightType)this.getLineItemType(FlightType.class, FlightType.DEFAULT);
    }

    public void setPNR(String pnr) {
        this._AVPList.add(AVPType.PASSENGER_NAME_RECORD.Code(), pnr);
    }

    public String getPNR() {
        return this._AVPList.get(AVPType.PASSENGER_NAME_RECORD.Code()).getValue();
    }

    public void setPassengerName(String passengerName) {
        this._AVPList.add(AVPType.PASSENGER_NAME.Code(), passengerName);
    }

    public String getPassengerName() {
        return this._AVPList.get(AVPType.PASSENGER_NAME.Code()).getValue();
    }

    public void setFlightDestinationType(FlightDestinationType flightDestinationType) {
        this._AVPList.add(AVPType.FLIGHT_DESTINATION_TYPE.Code(), flightDestinationType.code());
    }

    public FlightDestinationType getFlightDestinationType() {
        try {
            return FlightDestinationType.valueOf(this._AVPList.get(AVPType.FLIGHT_DESTINATION_TYPE.Code()).getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getDepartureDate() {
        return this.getDespatchDate();
    }

    public void setDepartureDate(Date departureDate) {
        this.setDespatchDate(departureDate);
    }

    public void setTicketNumber(String ticketNumber) {
        this._serialNumber = ticketNumber;
    }

    public String getTicketNumber() {
        return this._serialNumber;
    }
}

