/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.travel;

import java.util.Date;
import net.dreceiptx.receipt.ecom.AVPType;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.lineitem.travel.AccommodationType;

public class Accommodation
extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL0001";

    public Accommodation(AccommodationType accommodationType, String provider, String shortDescription, String longDescription, int nights, double rate) {
        super(provider, shortDescription, longDescription, nights, rate);
        this.setTradeItemGroupIdentificationCode(accommodationType.code());
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public Accommodation(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public String getProviderName() {
        return this.getBrandName();
    }

    public String getShortDescription() {
        return this.getName();
    }

    public String getDetailedDescription() {
        return this.getDescription();
    }

    public AccommodationType getAccommodationType() {
        return (AccommodationType)this.getLineItemType(AccommodationType.class, AccommodationType.DEFAULT);
    }

    public void setPassengerName(String passengerName) {
        this._AVPList.add(AVPType.PASSENGER_NAME.Code(), passengerName);
    }

    public Date getDepartureDate() {
        return this.getDespatchDate();
    }

    public void setDepartureDate(Date departureDate) {
        this.setDespatchDate(departureDate);
    }

    public Date getArrivalDate() {
        return this.getDeliveryDate();
    }

    public void setArrivalDate(Date arrivalDate) {
        this.setDeliveryDate(arrivalDate);
    }
}

