/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.document;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.dreceiptx.receipt.common.Contact;
import net.dreceiptx.receipt.common.ContactType;
import net.dreceiptx.receipt.document.ReceiptContactType;

public class ReceiptContact {
    @SerializedName(value="contactTypeCode")
    private ReceiptContactType _receiptContactType;
    @SerializedName(value="personName")
    private String _contact;
    @SerializedName(value="communicationChannelCode")
    private List<Contact> _contacts = new ArrayList<Contact>();

    public ReceiptContact(ReceiptContactType receiptContactType) {
        this._receiptContactType = receiptContactType;
    }

    public ReceiptContact(ReceiptContactType receiptContactType, String contactName) {
        this(receiptContactType);
        this._contact = contactName;
    }

    public ReceiptContactType getReceiptContactType() {
        return this._receiptContactType;
    }

    public void setReceiptContactType(ReceiptContactType receiptContactType) {
        this._receiptContactType = receiptContactType;
    }

    public String getContactName() {
        return this._contact;
    }

    public void setContactName(String contact) {
        this._contact = contact;
    }

    public String getEmailAddress() {
        for (Contact contact : this._contacts) {
            if (!contact.getType().equals((Object)ContactType.EMAIL)) continue;
            return contact.getContact();
        }
        return null;
    }

    public void addEmailAddress(String emailAddress) {
        this._contacts.add(new Contact(ContactType.EMAIL, emailAddress));
    }

    public String getContact() {
        return this._contact;
    }

    public String getTelephoneNumber() {
        for (Contact contact : this._contacts) {
            if (!contact.getType().equals((Object)ContactType.TELEPHONE)) continue;
            return contact.getContact();
        }
        return null;
    }

    public void addTelephoneNumber(String telephoneNumber) {
        this._contacts.add(new Contact(ContactType.TELEPHONE, telephoneNumber));
    }
}

