/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.common;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.dreceiptx.receipt.common.Address;
import net.dreceiptx.receipt.common.Contact;
import net.dreceiptx.receipt.common.GeographicalCoordinates;

public class LocationInformation {
    @SerializedName(value="address")
    private Address _address = null;
    @SerializedName(value="contact")
    private List<Contact> _contacts = null;

    public LocationInformation() {
    }

    public LocationInformation(Address address, Contact contact) {
        this._address = address;
        this.addContact(contact);
    }

    public LocationInformation(Address address) {
        this._address = address;
    }

    public LocationInformation(GeographicalCoordinates geographicalCoordinates) {
        this.setGeographicalCoordinates(geographicalCoordinates);
    }

    public LocationInformation(Contact contact) {
        this.addContact(contact);
    }

    public void addContact(Contact contact) {
        if (this._contacts == null) {
            this._contacts = new ArrayList<Contact>();
        }
        this._contacts.add(contact);
    }

    public void setAddress(Address address) {
        this._address = address;
    }

    public void setGeographicalCoordinates(GeographicalCoordinates geographicalCoordinates) {
        if (this._address != null) {
            this._address.setGeographicalCoordinates(geographicalCoordinates);
        } else {
            this._address = new Address(geographicalCoordinates);
        }
    }

    public Address getAddress() {
        return this._address;
    }

    public GeographicalCoordinates getGeographicalCoordinates() {
        if (this._address != null) {
            return this._address.getGeographicalCoordinates();
        }
        return null;
    }

    public List<Contact> getContacts() {
        return this._contacts;
    }

    public boolean gsonValidator() {
        return this._address != null || this._contacts != null && !this._contacts.isEmpty();
    }
}

