/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.common.Address;
import net.dreceiptx.receipt.common.Contact;
import net.dreceiptx.receipt.common.GeographicalCoordinates;
import net.dreceiptx.receipt.document.DocumentOwner;
import net.dreceiptx.receipt.document.ReceiptContact;
import net.dreceiptx.receipt.document.ReceiptContactType;
import net.dreceiptx.receipt.document.StandardBusinessDocumentHeader;
import net.dreceiptx.receipt.invoice.Invoice;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.serialization.json.InvoiceDeserializer;
import net.dreceiptx.receipt.serialization.json.LineItemDeserializer;
import net.dreceiptx.receipt.serialization.json.PaymentReceiptDeserializer;
import net.dreceiptx.receipt.settlement.PaymentReceipt;
import net.dreceiptx.receipt.tax.TaxCode;
import net.dreceiptx.receipt.validation.ReceiptDeserializationException;

public class DigitalReceipt {
    @SerializedName(value="standardBusinessDocumentHeader")
    private StandardBusinessDocumentHeader _standardBusinessDocumentHeader;
    @SerializedName(value="invoice")
    private Invoice _invoice;
    @SerializedName(value="paymentReceipts")
    private List<PaymentReceipt> _paymentReceipts;

    public DigitalReceipt(String digitalReceiptJson) throws ReceiptDeserializationException {
        JsonParser parser = new JsonParser();
        JsonObject digitalReceiptObject = parser.parse(digitalReceiptJson).getAsJsonObject().getAsJsonObject("dRxDigitalReceipt");
        Gson gson = new GsonBuilder().registerTypeAdapter(Invoice.class, (Object)new InvoiceDeserializer()).registerTypeHierarchyAdapter(LineItem.class, (Object)new LineItemDeserializer()).registerTypeAdapter(new TypeToken<List<PaymentReceipt>>(){}.getType(), (Object)new PaymentReceiptDeserializer()).create();
        this._standardBusinessDocumentHeader = (StandardBusinessDocumentHeader)gson.fromJson(digitalReceiptObject.get("standardBusinessDocumentHeader").toString(), StandardBusinessDocumentHeader.class);
        this._invoice = (Invoice)gson.fromJson(digitalReceiptObject.get("invoice").toString(), Invoice.class);
        this._paymentReceipts = (List)gson.fromJson(digitalReceiptObject.get("paymentReceipts").toString(), new TypeToken<List<PaymentReceipt>>(){}.getType());
        if (this._invoice == null || this._standardBusinessDocumentHeader.equals(null) || this._paymentReceipts.equals(null)) {
            throw new ReceiptDeserializationException("Failed to deserialize Digital Receipt data from source");
        }
    }

    public String getUserGUID() {
        return this._standardBusinessDocumentHeader.getUserIdentifier();
    }

    public String getMerchantName() {
        return this._invoice.getMerchantName();
    }

    public String getCompanyTaxNumber(TaxCode taxCode) {
        return this._invoice.getCompanyTaxNumber(taxCode);
    }

    public String getMerchantLocationReference() {
        return this._standardBusinessDocumentHeader.getMerchantGLN();
    }

    public Date getReceiptDate() {
        return this._invoice.getCreationDateTime();
    }

    public String getGUID() {
        return this._standardBusinessDocumentHeader.getDocumentIdentification().getInstanceIdentifier();
    }

    public String getReceiptReference() {
        return this._invoice.getInvoiceIdentification();
    }

    public String getPurchaseOrderNumber() {
        return this._invoice.getPurchaseOrder();
    }

    public String getCustomerReferenceNumber() {
        return this._invoice.getCustomerReference();
    }

    public String getSalesOrderReference() {
        return this._invoice.getSalesOrderReference();
    }

    public boolean isBillingInformationSet() {
        return this._invoice.isBillingInformationSet();
    }

    public String getBillingOrganisationName() {
        return this._invoice.getBillingOrganisationName();
    }

    public List<ReceiptContact> getMerchantCustomerRelations() {
        return this.getMerchantContact(ReceiptContactType.CUSTOMER_RELATIONS);
    }

    public List<ReceiptContact> getMerchantDeliveryContact() {
        return this.getMerchantContact(ReceiptContactType.DELIVERY_CONTACT);
    }

    public List<ReceiptContact> getMerchantSalesAssistant() {
        return this.getMerchantContact(ReceiptContactType.SALES_ADMINISTRATION);
    }

    private List<ReceiptContact> getMerchantContact(ReceiptContactType receiptContactType) {
        ArrayList<ReceiptContact> contacts = new ArrayList<ReceiptContact>();
        for (DocumentOwner sender : this._standardBusinessDocumentHeader.getSender()) {
            if (!sender.getIdentifier().getAuthority().equals("GS1")) continue;
            for (ReceiptContact contact : sender.getDocumentOwnerContact()) {
                if (!contact.getReceiptContactType().equals((Object)receiptContactType)) continue;
                contacts.add(contact);
            }
        }
        return contacts;
    }

    public List<ReceiptContact> getClientRecipientContact() {
        return this.getRMSContact(ReceiptContactType.RECIPIENT_CONTACT);
    }

    public List<ReceiptContact> getClientPurchasingContact() {
        return this.getRMSContact(ReceiptContactType.PURCHASING_CONTACT);
    }

    private List<ReceiptContact> getRMSContact(ReceiptContactType contactType) {
        ArrayList<ReceiptContact> contacts = new ArrayList<ReceiptContact>();
        for (DocumentOwner receiver : this._standardBusinessDocumentHeader.getReceiver()) {
            if (!receiver.getIdentifier().getAuthority().equals("dRx")) continue;
            if (receiver.getDocumentOwnerContact() == null) {
                return contacts;
            }
            for (ReceiptContact contact : receiver.getDocumentOwnerContact()) {
                if (!contact.getReceiptContactType().equals((Object)contactType)) continue;
                contacts.add(contact);
            }
        }
        return contacts;
    }

    public Address getDeliveryAddress() {
        return this._invoice.getDestinationInformation().getAddress();
    }

    public List<Contact> getCustomerDeliveryContactDetails() {
        return this._invoice.getDestinationInformation().getContacts();
    }

    public Address getOriginAddress() {
        return this._invoice.getOriginInformation().getAddress();
    }

    public List<Contact> getOriginContact() {
        return this._invoice.getOriginInformation().getContacts();
    }

    public GeographicalCoordinates getOriginCoordinates() {
        return this._invoice.getOriginInformation().getAddress().getGeographicalCoordinates();
    }

    public GeographicalCoordinates getDestinationCoordinates() {
        return this._invoice.getDestinationInformation().getAddress().getGeographicalCoordinates();
    }

    public List<LineItem> getLineItems() {
        return this._invoice.getInvoiceLineItems();
    }

    public List<ReceiptAllowanceCharge> getCharges() {
        ArrayList<ReceiptAllowanceCharge> charges = new ArrayList<ReceiptAllowanceCharge>();
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._invoice.getAllowanceOrCharges()) {
            if (!receiptAllowanceCharge.isCharge()) continue;
            charges.add(receiptAllowanceCharge);
        }
        return charges;
    }

    public List<ReceiptAllowanceCharge> getAllowances() {
        ArrayList<ReceiptAllowanceCharge> allowances = new ArrayList<ReceiptAllowanceCharge>();
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._invoice.getAllowanceOrCharges()) {
            if (!receiptAllowanceCharge.isAllowance()) continue;
            allowances.add(receiptAllowanceCharge);
        }
        return allowances;
    }

    public BigDecimal getTotal() {
        return this._invoice.getTotal();
    }

    public BigDecimal getSubTotal() {
        return this._invoice.getSubTotal();
    }

    public BigDecimal getTaxTotal(TaxCode taxCode) {
        return this._invoice.getTaxesTotal(taxCode);
    }
}

