/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.dreceiptx.receipt.allowanceCharge.ReceiptAllowanceCharge;
import net.dreceiptx.receipt.common.DespatchInformation;
import net.dreceiptx.receipt.common.LocationInformation;
import net.dreceiptx.receipt.ecom.AVP;
import net.dreceiptx.receipt.ecom.AVPList;
import net.dreceiptx.receipt.lineitem.LineItemTypeDescription;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TradeItemIdentification;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.tax.Tax;
import net.dreceiptx.receipt.tax.TaxCode;

public abstract class LineItem {
    protected transient int _lineItemId;
    protected transient int _quantity;
    protected transient BigDecimal _price;
    protected transient boolean _creditLineIndicator = false;
    protected final transient List<Tax> _taxes = new ArrayList<Tax>();
    protected final transient List<ReceiptAllowanceCharge> _receiptAllowanceCharges = new ArrayList<ReceiptAllowanceCharge>();
    protected transient DespatchInformation _despatchInformation = new DespatchInformation();
    protected transient TradeItemIdentification _tradeItemIdentification = new TradeItemIdentification();
    protected transient TradeItemDescriptionInformation _tradeItemDescriptionInformation = null;
    protected transient AVPList _AVPList = new AVPList();
    protected transient TransactionalTradeItemType _transactionalTradeItemType = null;
    protected transient String _transactionalTradeItemCode = null;
    protected transient String _serialNumber = null;
    protected transient String _batchNumber = null;
    protected transient String _billingCostCentre = null;
    protected transient LocationInformation _origin = new LocationInformation();
    protected transient LocationInformation _destination = new LocationInformation();
    public static final String LineItemTypeIdentifier = "DRX_LINEITEM_TYPE";

    protected LineItem() {
    }

    public LineItem(String brand, String name, String description, int quantity, double price) {
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this._tradeItemDescriptionInformation = new TradeItemDescriptionInformation(brand, name, description);
        this._quantity = quantity;
        this._price = BigDecimal.valueOf(price);
    }

    public LineItem(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this._tradeItemDescriptionInformation = tradeItemDescriptionInformation;
        this._quantity = quantity;
        this._price = BigDecimal.valueOf(price);
    }

    public LineItem(TransactionalTradeItemType transactionalTradeItemType, String transactionalTradeItemCode, int quantity, double price) {
        this._transactionalTradeItemType = transactionalTradeItemType;
        this._transactionalTradeItemCode = transactionalTradeItemCode;
        this._quantity = quantity;
        this._price = BigDecimal.valueOf(price);
    }

    public String getBrandName() {
        return this._tradeItemDescriptionInformation.getBrandName();
    }

    public String getName() {
        return this._tradeItemDescriptionInformation.getDescriptionShort();
    }

    public String getDescription() {
        return this._tradeItemDescriptionInformation.getTradeItemDescription();
    }

    public void setLineItemId(Integer lineItemId) {
        this._lineItemId = lineItemId;
    }

    public Integer getLineItemId() {
        return this._lineItemId;
    }

    public void setReturnOrExchange() {
        this._creditLineIndicator = true;
    }

    public boolean isReturnOrExchange() {
        return this._creditLineIndicator;
    }

    public void addReceiptAllowanceCharges(ReceiptAllowanceCharge receiptAllowanceCharge) {
        this._receiptAllowanceCharges.add(receiptAllowanceCharge);
    }

    public void setTradeItemDescriptionInformation(String brand, String name, String description) {
        if (this._tradeItemDescriptionInformation != null) {
            this._tradeItemDescriptionInformation.setBrandName(brand);
            this._tradeItemDescriptionInformation.setDescriptionShort(name);
            this._tradeItemDescriptionInformation.setTradeItemDescription(description);
        } else {
            this._tradeItemDescriptionInformation = new TradeItemDescriptionInformation(brand, name, description);
        }
    }

    public void setTradeItemDescriptionInformation(TradeItemDescriptionInformation tradeItemDescriptionInformation) {
        this._tradeItemDescriptionInformation = tradeItemDescriptionInformation;
    }

    protected void setTradeItemGroupIdentificationCode(String code) {
        if (this._tradeItemDescriptionInformation != null) {
            this._tradeItemDescriptionInformation.setTradeItemGroupIdentificationCode(code);
        }
    }

    protected <T extends Enum<T>> LineItemTypeDescription getLineItemType(Class<T> lineItemTypeDescription, LineItemTypeDescription defaultValue) {
        if (this._tradeItemDescriptionInformation != null) {
            for (Enum lineItemTypeDescriptionEnum : (Enum[])lineItemTypeDescription.getEnumConstants()) {
                if (!((LineItemTypeDescription)((Object)lineItemTypeDescriptionEnum)).code().equals(this._tradeItemDescriptionInformation.getTradeItemGroupIdentificationCode())) continue;
                return (LineItemTypeDescription)((Object)lineItemTypeDescriptionEnum);
            }
        }
        return defaultValue;
    }

    public TradeItemDescriptionInformation getTradeItemDescriptionInformation() {
        return this._tradeItemDescriptionInformation;
    }

    public void setTransactionalTradeItemType(TransactionalTradeItemType transactionalTradeItemType, String transactionalTradeItemCode) {
        this._transactionalTradeItemType = transactionalTradeItemType;
        this._transactionalTradeItemCode = transactionalTradeItemCode;
    }

    public TransactionalTradeItemType getTransactionalTradeItemType() {
        return this._transactionalTradeItemType;
    }

    public String getTransactionalTradeItemCode() {
        return this._transactionalTradeItemCode;
    }

    public void setTradeItemIdentification(TradeItemIdentification tradeItemIdentification) {
        this._tradeItemIdentification = tradeItemIdentification;
    }

    public TradeItemIdentification getTradeItemIdentification() {
        return this._tradeItemIdentification;
    }

    public void addTradeItemIdentification(String code, String value) {
        this._tradeItemIdentification.add(code, value);
    }

    public boolean hasTradeItemIdentificationValue(String code) {
        return this._tradeItemIdentification.has(code);
    }

    public String getTradeItemIdentificationValue(String code) {
        if (this._tradeItemIdentification.has(code)) {
            return this._tradeItemIdentification.get(code);
        }
        return null;
    }

    public AVPList getEcomAVPList() {
        return this._AVPList;
    }

    public void addEcomAVP(AVP avp) {
        this._AVPList.add(avp);
    }

    public void setSerialNumber(String serialNumber) {
        this._serialNumber = serialNumber;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }

    public void setBatchNumber(String batchNumber) {
        this._batchNumber = batchNumber;
    }

    public String getBatchNumber() {
        return this._batchNumber;
    }

    public void setBillingCostCentre(String billingCostCentre) {
        this._billingCostCentre = billingCostCentre;
    }

    public String getBillingCostCentre() {
        return this._billingCostCentre;
    }

    public void setDespatchDate(Date despatchDate) {
        this._despatchInformation.setDespatchDate(despatchDate);
    }

    public Date getDespatchDate() {
        return this._despatchInformation.getDespatchDate();
    }

    public void setDeliveryDate(Date deliveryDate) {
        this._despatchInformation.setDeliveryDate(deliveryDate);
    }

    public Date getDeliveryDate() {
        return this._despatchInformation.getDeliveryDate();
    }

    public void setDeliveryInstructions(String deliveryInstructions) {
        this._despatchInformation.setInstructions(deliveryInstructions);
    }

    public String getDeliveryInstructions() {
        return this._despatchInformation.getDeliveryInstructions();
    }

    public void setDespatchInformation(DespatchInformation despatchInformation) {
        this._despatchInformation = despatchInformation;
    }

    public DespatchInformation getDespatchInformation() {
        return this._despatchInformation;
    }

    public void setOriginInformation(LocationInformation originInformation) {
        this._origin = originInformation;
    }

    public LocationInformation getOriginInformation() {
        return this._origin;
    }

    public void setDestinationInformation(LocationInformation destinationInformation) {
        this._destination = destinationInformation;
    }

    public LocationInformation getDestinationInformation() {
        return this._destination;
    }

    public BigDecimal getSubTotal() {
        return this._price.multiply(BigDecimal.valueOf(this._quantity));
    }

    public BigDecimal getNetTotal() {
        BigDecimal total = this.getSubTotal();
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._receiptAllowanceCharges) {
            total = total.add(receiptAllowanceCharge.getNetTotal());
        }
        return total;
    }

    public BigDecimal getTotal() {
        BigDecimal total = this.getSubTotal();
        for (Tax tax : this._taxes) {
            total = total.add(tax.getTaxTotal());
        }
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._receiptAllowanceCharges) {
            total = total.add(receiptAllowanceCharge.getSubTotal());
        }
        return total;
    }

    public BigDecimal getTaxesTotal() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (Tax tax : this._taxes) {
            total = total.add(tax.getTaxTotal());
        }
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._receiptAllowanceCharges) {
            total = total.add(receiptAllowanceCharge.getTaxesTotal());
        }
        return total;
    }

    public BigDecimal getTaxesTotal(TaxCode taxCode) {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (Tax tax : this._taxes) {
            TaxCode tc = tax.getTaxCode();
            if (tc == null || !tc.equals((Object)taxCode)) continue;
            total = total.add(tax.getTaxTotal());
        }
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._receiptAllowanceCharges) {
            total = total.add(receiptAllowanceCharge.getTaxesTotal(taxCode));
        }
        return total;
    }

    public BigDecimal getAllowancesTotal() {
        BigDecimal total = BigDecimal.valueOf(0L);
        for (ReceiptAllowanceCharge receiptAllowanceCharge : this._receiptAllowanceCharges) {
            total = total.add(receiptAllowanceCharge.getNetTotal());
        }
        return total;
    }

    public List<ReceiptAllowanceCharge> getReceiptAllowanceCharges() {
        return this._receiptAllowanceCharges;
    }

    public void addTax(Tax tax) {
        this._taxes.add(tax);
    }

    public List<Tax> getTaxes() {
        return this._taxes;
    }

    public long getQuantity() {
        return this._quantity;
    }

    public void setQuantity(int quantity) {
        this._quantity = quantity;
    }

    public BigDecimal getPrice() {
        return this._price;
    }

    public void setPrice(BigDecimal price) {
        this._price = price;
    }

    public boolean hasTaxes() {
        return !this._taxes.isEmpty();
    }
}

