/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.document;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.dreceiptx.receipt.document.DocumentIdentification;
import net.dreceiptx.receipt.document.DocumentOwner;
import net.dreceiptx.receipt.document.ReceiptContact;
import net.dreceiptx.receipt.validation.ReceiptValidation;

public class StandardBusinessDocumentHeader {
    @SerializedName(value="sender")
    private List<DocumentOwner> _sender = new ArrayList<DocumentOwner>();
    @SerializedName(value="receiver")
    private List<DocumentOwner> _receiver = new ArrayList<DocumentOwner>();
    @SerializedName(value="documentIdentification")
    private DocumentIdentification _documentIdentification = new DocumentIdentification();

    public StandardBusinessDocumentHeader() {
        DocumentOwner merchant = new DocumentOwner();
        merchant.getIdentifier().setAuthority("GS1");
        merchant.getIdentifier().setValue(null);
        this._sender.add(0, merchant);
        DocumentOwner dRx = new DocumentOwner();
        dRx.getIdentifier().setAuthority("GS1");
        dRx.getIdentifier().setValue(null);
        this._receiver.add(0, dRx);
        DocumentOwner user = new DocumentOwner();
        user.getIdentifier().setAuthority("dRx");
        user.getIdentifier().setValue(null);
        this._receiver.add(1, user);
    }

    public void setMerchantGLN(String merchantGLN) {
        this._sender.get(0).setValue(merchantGLN);
    }

    public String getMerchantGLN() {
        return this._sender.get(0).getValue();
    }

    public void setdRxGLN(String dRxGLN) {
        this._receiver.get(0).setValue(dRxGLN);
    }

    public String getdRxGLN() {
        return this._receiver.get(0).getValue();
    }

    public void setUserIdentifier(String userIdentifier) {
        this._receiver.get(1).setValue(userIdentifier);
    }

    public String getUserIdentifier() {
        return this._receiver.get(1).getValue();
    }

    public List<ReceiptContact> getClientContacts() {
        return this._receiver.get(1).getDocumentOwnerContact();
    }

    public void addMerchantContact(ReceiptContact contact) {
        this._sender.get(0).addDocumentOwnerContact(contact);
    }

    public void addRMSContact(ReceiptContact contact) {
        this._receiver.get(1).addDocumentOwnerContact(contact);
    }

    public List<DocumentOwner> getReceiver() {
        return this._receiver;
    }

    public List<DocumentOwner> getSender() {
        return this._sender;
    }

    public void addReceiver(DocumentOwner receiver) {
        this._receiver.add(receiver);
    }

    public DocumentIdentification getDocumentIdentification() {
        return this._documentIdentification;
    }

    public void setDocumentIdentification(DocumentIdentification documentIdentification) {
        this._documentIdentification = documentIdentification;
    }

    public ReceiptValidation validate(ReceiptValidation receiptValidation) {
        if (this._sender.isEmpty()) {
            receiptValidation.AddError("Merchant GLN must be set.");
        }
        return receiptValidation;
    }
}

