/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.users;

public class NewUserRegistrationResult {
    private boolean _success;
    private Integer _code;
    private String _message;
    private String _userGUID;
    
    public void setUserGUID(String userGUID) {
        _success = true;
        _code = 201;
        _userGUID = userGUID;
    }
    
    public void setException(Integer code, String message) {
        _success = false;
        _code = code;
        _message = message;
    }

    public boolean isSuccess() {
        return _success;
    }
    
    public Integer getCode() {
        return _code;
    }

    public String getMessage() {
        return _message;
    }

    public String getUserGUID() {
        return _userGUID;
    }
}
