/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.tax;

import com.google.gson.annotations.SerializedName;

import java.math.BigDecimal;

public class Tax {
    @SerializedName("dutyFeeTaxCategoryCode") private TaxCategory _category  = null;
    @SerializedName("dutyFeeTaxTypeCode") private TaxCode _code = null;
    @SerializedName("dutyFeeTaxBasisAmount") private BigDecimal _taxableAmount;
    @SerializedName("dutyFeeTaxPercentage") private BigDecimal _rate;
    @SerializedName("dutyFeeTaxAmount") private BigDecimal _totalTax;

    public Tax(double taxableAmount, double totalTax)
    {
        _taxableAmount = BigDecimal.valueOf(taxableAmount);
        _totalTax = BigDecimal.valueOf(totalTax);
        if( totalTax != 0) {
            _rate = _totalTax.divide(_taxableAmount, BigDecimal.ROUND_HALF_DOWN).multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_EVEN);
        } else {
            _rate = BigDecimal.ZERO;
        }
    }

    public Tax(TaxCategory category, TaxCode code, double taxableAmount, double totalTax) {
        this(taxableAmount, totalTax);
        _category = category;
        _code = code;
    }
    
    public void setTaxCategory(TaxCategory taxCategory){
        _category = taxCategory;
    }
    
    public void setTaxCode(TaxCode taxCode){
        _code = taxCode;
    }
    
    public BigDecimal getTaxRate() {
        return _rate;
    }
    
    public BigDecimal getTaxableAmount() {
        return _taxableAmount;
    }

    public BigDecimal getTaxTotal() {
        return _totalTax;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        _totalTax = taxTotal;
    }
    
    public TaxCategory getTaxCategory() {
        return _category;
    }
    
    public TaxCode getTaxCode() {
        return _code;
    }

    // TODO: Consider renaming to IsTaxCode
    public boolean is(TaxCode taxCode){
        return (taxCode == _code);
    }
}
